/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileRecordReader<K, V>
implements RecordReader<K, V> {
    private SequenceFile.Reader in;
    private long start;
    private long end;
    private boolean more = true;
    protected Configuration conf;

    public SequenceFileRecordReader(Configuration conf, FileSplit split2) throws IOException {
        Path path = split2.getPath();
        FileSystem fs = path.getFileSystem(conf);
        this.in = new SequenceFile.Reader(fs, path, conf);
        this.end = split2.getStart() + split2.getLength();
        this.conf = conf;
        if (split2.getStart() > this.in.getPosition()) {
            this.in.sync(split2.getStart());
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
    }

    public Class getKeyClass() {
        return this.in.getKeyClass();
    }

    public Class getValueClass() {
        return this.in.getValueClass();
    }

    @Override
    public K createKey() {
        return (K)ReflectionUtils.newInstance(this.getKeyClass(), this.conf);
    }

    @Override
    public V createValue() {
        return (V)ReflectionUtils.newInstance(this.getValueClass(), this.conf);
    }

    @Override
    public synchronized boolean next(K key, V value2) throws IOException {
        boolean remaining;
        if (!this.more) {
            return false;
        }
        long pos = this.in.getPosition();
        boolean bl = remaining = this.in.next(key) != null;
        if (remaining) {
            this.getCurrentValue(value2);
        }
        this.more = pos >= this.end && this.in.syncSeen() ? false : remaining;
        return this.more;
    }

    protected synchronized boolean next(K key) throws IOException {
        if (!this.more) {
            return false;
        }
        long pos = this.in.getPosition();
        boolean remaining = this.in.next(key) != null;
        this.more = pos >= this.end && this.in.syncSeen() ? false : remaining;
        return this.more;
    }

    protected synchronized void getCurrentValue(V value2) throws IOException {
        this.in.getCurrentValue(value2);
    }

    @Override
    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.in.getPosition();
    }

    protected synchronized void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    @Override
    public synchronized void close() throws IOException {
        this.in.close();
    }
}

