/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MapRunner<K1, V1, K2, V2>
implements MapRunnable<K1, V1, K2, V2> {
    private Mapper<K1, V1, K2, V2> mapper;
    private boolean incrProcCount;

    @Override
    public void configure(JobConf job) {
        this.mapper = ReflectionUtils.newInstance(job.getMapperClass(), job);
        this.incrProcCount = SkipBadRecords.getMapperMaxSkipRecords(job) > 0L && SkipBadRecords.getAutoIncrMapperProcCount(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RecordReader<K1, V1> input2, OutputCollector<K2, V2> output, Reporter reporter) throws IOException {
        try {
            K1 key = input2.createKey();
            V1 value2 = input2.createValue();
            while (input2.next(key, value2)) {
                this.mapper.map(key, value2, output, reporter);
                if (!this.incrProcCount) continue;
                reporter.incrCounter("SkippingTaskCounters", "MapProcessedRecords", 1L);
            }
        }
        finally {
            this.mapper.close();
        }
    }

    protected Mapper<K1, V1, K2, V2> getMapper() {
        return this.mapper;
    }
}

