/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.google.common.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class DirectBufferPool {
    ConcurrentMap<Integer, Queue<WeakReference<ByteBuffer>>> buffersBySize = new ConcurrentHashMap<Integer, Queue<WeakReference<ByteBuffer>>>();

    public ByteBuffer getBuffer(int size2) {
        WeakReference ref;
        Queue list2 = (Queue)this.buffersBySize.get(size2);
        if (list2 == null) {
            return ByteBuffer.allocateDirect(size2);
        }
        while ((ref = (WeakReference)list2.poll()) != null) {
            ByteBuffer b = (ByteBuffer)ref.get();
            if (b == null) continue;
            return b;
        }
        return ByteBuffer.allocateDirect(size2);
    }

    public void returnBuffer(ByteBuffer buf) {
        buf.clear();
        int size2 = buf.capacity();
        Queue<WeakReference<ByteBuffer>> list2 = (ConcurrentLinkedQueue<WeakReference<ByteBuffer>>)this.buffersBySize.get(size2);
        if (list2 == null) {
            list2 = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();
            Queue prev = this.buffersBySize.putIfAbsent(size2, list2);
            if (prev != null) {
                list2 = prev;
            }
        }
        list2.add(new WeakReference<ByteBuffer>(buf));
    }

    @VisibleForTesting
    int countBuffersOfSize(int size2) {
        Queue list2 = (Queue)this.buffersBySize.get(size2);
        if (list2 == null) {
            return 0;
        }
        return list2.size();
    }
}

