/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotStats;

public class SnapshotManager
implements SnapshotStats {
    private boolean allowNestedSnapshots = false;
    private final FSDirectory fsdir;
    private static final int SNAPSHOT_ID_BIT_WIDTH = 24;
    private final AtomicInteger numSnapshots = new AtomicInteger();
    private int snapshotCounter = 0;
    private final Map<Long, INodeDirectorySnapshottable> snapshottables = new HashMap<Long, INodeDirectorySnapshottable>();

    public SnapshotManager(FSDirectory fsdir) {
        this.fsdir = fsdir;
    }

    void setAllowNestedSnapshots(boolean allowNestedSnapshots) {
        this.allowNestedSnapshots = allowNestedSnapshots;
    }

    private void checkNestedSnapshottable(INodeDirectory dir, String path) throws SnapshotException {
        if (this.allowNestedSnapshots) {
            return;
        }
        for (INodeDirectorySnapshottable s2 : this.snapshottables.values()) {
            if (s2.isAncestorDirectory(dir)) {
                throw new SnapshotException("Nested snapshottable directories not allowed: path=" + path + ", the subdirectory " + s2.getFullPathName() + " is already a snapshottable directory.");
            }
            if (!dir.isAncestorDirectory(s2)) continue;
            throw new SnapshotException("Nested snapshottable directories not allowed: path=" + path + ", the ancestor " + s2.getFullPathName() + " is already a snapshottable directory.");
        }
    }

    public void setSnapshottable(String path, boolean checkNestedSnapshottable) throws IOException {
        INodeDirectorySnapshottable s2;
        INodesInPath iip = this.fsdir.getINodesInPath4Write(path);
        INodeDirectory d = INodeDirectory.valueOf(iip.getLastINode(), path);
        if (checkNestedSnapshottable) {
            this.checkNestedSnapshottable(d, path);
        }
        if (d.isSnapshottable()) {
            s2 = (INodeDirectorySnapshottable)d;
            s2.setSnapshotQuota(65536);
        } else {
            s2 = d.replaceSelf4INodeDirectorySnapshottable(iip.getLatestSnapshot(), this.fsdir.getINodeMap());
        }
        this.addSnapshottable(s2);
    }

    public void addSnapshottable(INodeDirectorySnapshottable dir) {
        this.snapshottables.put(dir.getId(), dir);
    }

    private void removeSnapshottable(INodeDirectorySnapshottable s2) {
        this.snapshottables.remove(s2.getId());
    }

    public void removeSnapshottable(List<INodeDirectorySnapshottable> toRemove) {
        if (toRemove != null) {
            for (INodeDirectorySnapshottable s2 : toRemove) {
                this.removeSnapshottable(s2);
            }
        }
    }

    public void resetSnapshottable(String path) throws IOException {
        INodesInPath iip = this.fsdir.getINodesInPath4Write(path);
        INodeDirectory d = INodeDirectory.valueOf(iip.getLastINode(), path);
        if (!d.isSnapshottable()) {
            return;
        }
        INodeDirectorySnapshottable s2 = (INodeDirectorySnapshottable)d;
        if (s2.getNumSnapshots() > 0) {
            throw new SnapshotException("The directory " + path + " has snapshot(s). " + "Please redo the operation after removing all the snapshots.");
        }
        if (s2 == this.fsdir.getRoot()) {
            s2.setSnapshotQuota(0);
        } else {
            s2.replaceSelf(iip.getLatestSnapshot(), this.fsdir.getINodeMap());
        }
        this.removeSnapshottable(s2);
    }

    public INodeDirectorySnapshottable getSnapshottableRoot(String path) throws IOException {
        INodesInPath i = this.fsdir.getINodesInPath4Write(path);
        return INodeDirectorySnapshottable.valueOf(i.getLastINode(), path);
    }

    public String createSnapshot(String path, String snapshotName) throws IOException {
        INodeDirectorySnapshottable srcRoot = this.getSnapshottableRoot(path);
        if (this.snapshotCounter == this.getMaxSnapshotID()) {
            throw new SnapshotException("Failed to create the snapshot. The FileSystem has run out of snapshot IDs and ID rollover is not supported.");
        }
        srcRoot.addSnapshot(this.snapshotCounter, snapshotName);
        ++this.snapshotCounter;
        this.numSnapshots.getAndIncrement();
        return Snapshot.getSnapshotPath(path, snapshotName);
    }

    public void deleteSnapshot(String path, String snapshotName, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws IOException {
        INodeDirectorySnapshottable srcRoot = this.getSnapshottableRoot(path);
        srcRoot.removeSnapshot(snapshotName, collectedBlocks, removedINodes);
        this.numSnapshots.getAndDecrement();
    }

    public void renameSnapshot(String path, String oldSnapshotName, String newSnapshotName) throws IOException {
        INodeDirectorySnapshottable srcRoot = INodeDirectorySnapshottable.valueOf(this.fsdir.getINode(path), path);
        srcRoot.renameSnapshot(path, oldSnapshotName, newSnapshotName);
    }

    @Override
    public int getNumSnapshottableDirs() {
        return this.snapshottables.size();
    }

    @Override
    public int getNumSnapshots() {
        return this.numSnapshots.get();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.snapshotCounter);
        out.writeInt(this.numSnapshots.get());
        for (INodeDirectorySnapshottable snapshottableDir : this.snapshottables.values()) {
            for (Snapshot s2 : snapshottableDir.getSnapshotsByNames()) {
                s2.write(out);
            }
        }
    }

    public Map<Integer, Snapshot> read(DataInput in, FSImageFormat.Loader loader) throws IOException {
        this.snapshotCounter = in.readInt();
        this.numSnapshots.set(in.readInt());
        HashMap<Integer, Snapshot> snapshotMap = new HashMap<Integer, Snapshot>();
        for (int i = 0; i < this.numSnapshots.get(); ++i) {
            Snapshot s2 = Snapshot.read(in, loader);
            snapshotMap.put(s2.getId(), s2);
        }
        return snapshotMap;
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing(String userName) {
        if (this.snapshottables.isEmpty()) {
            return null;
        }
        ArrayList<SnapshottableDirectoryStatus> statusList = new ArrayList<SnapshottableDirectoryStatus>();
        for (INodeDirectorySnapshottable dir : this.snapshottables.values()) {
            if (userName != null && !userName.equals(dir.getUserName())) continue;
            SnapshottableDirectoryStatus status = new SnapshottableDirectoryStatus(dir.getModificationTime(), dir.getAccessTime(), dir.getFsPermission(), dir.getUserName(), dir.getGroupName(), dir.getLocalNameBytes(), dir.getId(), dir.getChildrenNum(null), dir.getNumSnapshots(), dir.getSnapshotQuota(), dir.getParent() == null ? DFSUtil.EMPTY_BYTES : DFSUtil.string2Bytes(dir.getParent().getFullPathName()));
            statusList.add(status);
        }
        Collections.sort(statusList, SnapshottableDirectoryStatus.COMPARATOR);
        return statusList.toArray(new SnapshottableDirectoryStatus[statusList.size()]);
    }

    public INodeDirectorySnapshottable.SnapshotDiffInfo diff(String path, String from2, String to2) throws IOException {
        if ((from2 == null || from2.isEmpty()) && (to2 == null || to2.isEmpty())) {
            return null;
        }
        INodesInPath inodesInPath = this.fsdir.getINodesInPath4Write(path.toString());
        INodeDirectorySnapshottable snapshotRoot = INodeDirectorySnapshottable.valueOf(inodesInPath.getLastINode(), path);
        return snapshotRoot.computeDiff(from2, to2);
    }

    public int getMaxSnapshotID() {
        return 0xFFFFFF;
    }
}

