/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.proto.RefreshAuthorizationPolicyProtocolProtos;
import org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Log LOG = NameNode.LOG;
    private static final Log stateChangeLog = NameNode.stateChangeLog;
    private static final Log blockStateChangeLog = NameNode.blockStateChangeLog;
    protected final FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        InetSocketAddress listenAddr;
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        RPC.setProtocolEngine(conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService(clientProtocolServerTranslator);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB(this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService(refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService(refreshUserMappingXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService(getUserMappingXlator);
        HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB(this);
        BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService(haServiceProtocolXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress serviceRpcAddr = nn.getServiceRpcServerAddress(conf);
        if (serviceRpcAddr != null) {
            String bindHost = nn.getServiceRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = serviceRpcAddr.getHostName();
            }
            LOG.info("Service RPC server is binding to " + bindHost + ":" + serviceRpcAddr.getPort());
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(serviceRpcAddr.getPort()).setNumHandlers(serviceHandlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            listenAddr = this.serviceRpcServer.getListenerAddress();
            this.serviceRPCAddress = new InetSocketAddress(serviceRpcAddr.getHostName(), listenAddr.getPort());
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        InetSocketAddress rpcAddr = nn.getRpcServerAddress(conf);
        String bindHost = nn.getRpcServerBindHost(conf);
        if (bindHost == null) {
            bindHost = rpcAddr.getHostName();
        }
        LOG.info("RPC server is binding to " + bindHost + ":" + rpcAddr.getPort());
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(rpcAddr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
        DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            }
        }
        listenAddr = this.clientRpcServer.getListenerAddress();
        this.clientRpcAddress = new InetSocketAddress(rpcAddr.getHostName(), listenAddr.getPort());
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.1.0-beta");
        this.clientRpcServer.addTerseExceptions(SafeModeException.class, FileNotFoundException.class, HadoopIllegalArgumentException.class, FileAlreadyExistsException.class, InvalidPathException.class, ParentNotDirectoryException.class, UnresolvedLinkException.class, AlreadyBeingCreatedException.class, QuotaExceededException.class, RecoveryInProgressException.class, AccessControlException.class, SecretManager.InvalidToken.class, LeaseExpiredException.class, NSQuotaExceededException.class, DSQuotaExceededException.class);
    }

    @VisibleForTesting
    RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.join();
        }
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size2) throws IOException {
        if (size2 <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size2);
        }
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlocks(datanode, size2);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        LOG.info("Error report from " + registration + ": " + msg);
        if (errorCode == 1) {
            this.namesystem.releaseBackupNode(registration);
        }
    }

    @Override
    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.verifyLayoutVersion(registration.getVersion());
        NamenodeRegistration myRegistration = this.nn.setRegistration();
        this.namesystem.registerBackupNode(registration, myRegistration);
        return myRegistration;
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        if (!this.nn.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            throw new IOException("Only an ACTIVE node can invoke startCheckpoint.");
        }
        return this.namesystem.startCheckpoint(registration, this.nn.setRegistration());
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.namesystem.endCheckpoint(registration, sig);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token2) throws SecretManager.InvalidToken, IOException {
        return this.namesystem.renewDelegationToken(token2);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token2) throws IOException {
        this.namesystem.cancelDelegationToken(token2);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.metrics.incrGetBlockLocations();
        return this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.namesystem.getServerDefaults();
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        HdfsFileStatus fileStatus = this.namesystem.startFile(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), clientName, clientMachine, flag.get(), createParent, replication, blockSize);
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
        return fileStatus;
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine);
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        this.metrics.incrFilesAppended();
        return info;
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes) throws IOException {
        List<String> favoredNodesList;
        LocatedBlock locatedBlock;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*BLOCK* NameNode.addBlock: file " + src + " fileId=" + fileId + " for " + clientName);
        }
        HashMap<Node, Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashMap<Node, Node>(excludedNodes.length);
            for (DatanodeInfo node : excludedNodes) {
                excludedNodesSet.put(node, node);
            }
        }
        if ((locatedBlock = this.namesystem.getAdditionalBlock(src, fileId, clientName, previous, excludedNodesSet, favoredNodesList = favoredNodes == null ? null : Arrays.asList(favoredNodes))) != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAdditionalDatanode: src=" + src + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName);
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashMap<Node, Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashMap<Node, Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.put(node, node);
            }
        }
        return this.namesystem.getAdditionalDatanode(src, blk, existings, excludeSet, numAdditionalNodes, clientName);
    }

    @Override
    public void abandonBlock(ExtendedBlock b, String src, String holder) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src);
        }
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last2, long fileId) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.complete: " + src + " fileId=" + fileId + " for " + clientName);
        }
        return this.namesystem.completeFile(src, clientName, last2, fileId);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namesystem.reportBadBlocks(blocks);
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes);
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.namesystem.concat(trg, src);
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        this.namesystem.renameTo(src, dst, options);
        this.metrics.incrFilesRenamed();
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive);
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= HdfsConstants.MAX_PATH_LENGTH && srcPath.depth() <= HdfsConstants.MAX_PATH_DEPTH;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.mkdirs: " + src);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public boolean isFileClosed(String src) throws IOException {
        return this.namesystem.isFileClosed(src);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        NameNode.OperationCategory opCategory = NameNode.OperationCategory.UNCHECKED;
        if (isChecked) {
            opCategory = action == HdfsConstants.SafeModeAction.SAFEMODE_GET ? NameNode.OperationCategory.READ : NameNode.OperationCategory.WRITE;
        }
        this.namesystem.checkOperation(opCategory);
        return this.namesystem.setSafeMode(action);
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        return this.namesystem.restoreFailedStorage(arg);
    }

    @Override
    public void saveNamespace() throws IOException {
        this.namesystem.saveNamespace();
    }

    @Override
    public long rollEdits() throws AccessControlException, IOException {
        CheckpointSignature sig = this.namesystem.rollEditLog();
        return sig.getCurSegmentTxId();
    }

    @Override
    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes();
    }

    @Override
    public long getTransactionID() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getLastAppliedOrWrittenTxId();
    }

    @Override
    public long getMostRecentCheckpointTxId() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getMostRecentCheckpointTxId();
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.rollEditLog();
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().getEditLogManifest(sinceTxId);
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        this.namesystem.finalizeUpgrade();
    }

    @Override
    public void metaSave(String filename) throws IOException {
        this.namesystem.metaSave(filename);
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namesystem.setBalancerBandwidth(bandwidth);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.namesystem.setQuota(path, namespaceQuota, diskspaceQuota);
    }

    @Override
    public void fsync(String src, String clientName, long lastBlockLength) throws IOException {
        this.namesystem.fsync(src, clientName, lastBlockLength);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.metrics.incrCreateSymlinkOps();
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds " + HdfsConstants.MAX_PATH_LENGTH + " character limit");
        }
        if ("".equals(target)) {
            throw new IOException("Invalid symlink target");
        }
        UserGroupInformation ugi = NameNodeRpcServer.getRemoteUser();
        this.namesystem.createSymlink(target, link, new PermissionStatus(ugi.getShortUserName(), null, dirPerms), createParent);
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        this.metrics.incrGetLinkTargetOps();
        HdfsFileStatus stat = null;
        try {
            stat = this.namesystem.getFileInfo(path, false);
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        if (stat == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!stat.isSymlink()) {
            throw new IOException("Path " + path + " is not a symbolic link");
        }
        return stat.getSymlink();
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.verifyLayoutVersion(nodeReg.getVersion());
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] report, int xmitsInProgress, int xceiverCount, int failedVolumes) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, report[0].getCapacity(), report[0].getDfsUsed(), report[0].getRemaining(), report[0].getBlockPoolUsed(), xceiverCount, xmitsInProgress, failedVolumes);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, String poolId, StorageBlockReport[] reports) throws IOException {
        this.verifyRequest(nodeReg);
        BlockListAsLongs blist = new BlockListAsLongs(reports[0].getBlocks());
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReport: from " + nodeReg + " " + blist.getNumberOfBlocks() + " blocks");
        }
        this.namesystem.getBlockManager().processReport(nodeReg, poolId, blist);
        if (this.nn.getFSImage().isUpgradeFinalized() && !this.nn.isStandbyState()) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks.");
        }
        this.namesystem.processIncrementalBlockReport(nodeReg, poolId, receivedAndDeletedBlocks[0].getBlocks());
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        String string2 = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info("Error report from " + dnName + ": " + msg);
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn("Disk error on " + dnName + ": " + msg);
        } else if (errorCode == 3) {
            LOG.warn("Fatal disk error on " + dnName + ": " + msg);
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg);
        } else {
            LOG.info("Error report from " + dnName + ": " + msg);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getNamespaceInfo();
    }

    void verifyRequest(NodeRegistration nodeReg) throws IOException {
        this.verifyLayoutVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            LOG.warn("Invalid registrationID - expected: " + this.namesystem.getRegistrationID() + " received: " + nodeReg.getRegistrationID());
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        }
    }

    @Override
    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info("Refreshing all user-to-groups mappings. Requested by user: " + NameNodeRpcServer.getRemoteUser().getShortUserName());
        Groups.getUserToGroupsMappingService().refresh();
    }

    @Override
    public void refreshSuperUserGroupsConfiguration() {
        LOG.info("Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    @Override
    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting groups for user " + user);
        }
        return UserGroupInformation.createRemoteUser(user).getGroupNames();
    }

    @Override
    public synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException {
        this.nn.monitorHealth();
    }

    @Override
    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException {
        this.nn.checkHaStateChange(req);
        this.nn.transitionToActive();
    }

    @Override
    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException {
        this.nn.checkHaStateChange(req);
        this.nn.transitionToStandby();
    }

    @Override
    public synchronized HAServiceStatus getServiceStatus() throws AccessControlException, ServiceFailedException {
        return this.nn.getServiceStatus();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsConstants.LAYOUT_VERSION) {
            throw new IncorrectVersionException(version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions(dnVersion, this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn(ive.getMessage() + " DN: " + dnReg);
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = this.nn.getFSImage().getStorage().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn(ive);
                throw ive;
            }
            LOG.info(messagePrefix + ". Note: This is normal during a rolling upgrade.");
        }
    }

    private static String getClientMachine() {
        String clientMachine = NamenodeWebHdfsMethods.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = Server.getRemoteAddress();
        }
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        return this.namesystem.getBlockManager().generateDataEncryptionKey();
    }

    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        if (!this.checkPathLength(snapshotRoot)) {
            throw new IOException("createSnapshot: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        this.metrics.incrCreateSnapshotOps();
        return this.namesystem.createSnapshot(snapshotRoot, snapshotName);
    }

    @Override
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.metrics.incrDeleteSnapshotOps();
        this.namesystem.deleteSnapshot(snapshotRoot, snapshotName);
    }

    @Override
    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.metrics.incrAllowSnapshotOps();
        this.namesystem.allowSnapshot(snapshotRoot);
    }

    @Override
    public void disallowSnapshot(String snapshot) throws IOException {
        this.metrics.incrDisAllowSnapshotOps();
        this.namesystem.disallowSnapshot(snapshot);
    }

    @Override
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        if (snapshotNewName == null || snapshotNewName.isEmpty()) {
            throw new IOException("The new snapshot name is null or empty.");
        }
        this.metrics.incrRenameSnapshotOps();
        this.namesystem.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName);
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        SnapshottableDirectoryStatus[] status = this.namesystem.getSnapshottableDirListing();
        this.metrics.incrListSnapshottableDirOps();
        return status;
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        SnapshotDiffReport report = this.namesystem.getSnapshotDiffReport(snapshotRoot, earlierSnapshotName, laterSnapshotName);
        this.metrics.incrSnapshotDiffReportOps();
        return report;
    }
}

