/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

public class INodeMap {
    private final GSet<INode, INodeWithAdditionalFields> map;

    static INodeMap newInstance(INodeDirectory rootDir) {
        int capacity = LightWeightGSet.computeCapacity(1.0, "INodeMap");
        LightWeightGSet<INode, INodeWithAdditionalFields> map2 = new LightWeightGSet<INode, INodeWithAdditionalFields>(capacity);
        map2.put(rootDir);
        return new INodeMap(map2);
    }

    private INodeMap(GSet<INode, INodeWithAdditionalFields> map2) {
        Preconditions.checkArgument(map2 != null);
        this.map = map2;
    }

    public final void put(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.map.put((INodeWithAdditionalFields)inode);
        }
    }

    public final void remove(INode inode) {
        this.map.remove(inode);
    }

    public int size() {
        return this.map.size();
    }

    public INode get(long id) {
        INodeWithAdditionalFields inode = new INodeWithAdditionalFields(id, null, new PermissionStatus("", "", new FsPermission(0)), 0L, 0L){

            @Override
            INode recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
                return null;
            }

            @Override
            public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            }

            @Override
            public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
                return null;
            }

            @Override
            public Content.Counts computeContentSummary(Content.Counts counts) {
                return null;
            }

            @Override
            public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, boolean countDiffChange) throws QuotaExceededException {
                return null;
            }
        };
        return this.map.get(inode);
    }

    public void clear() {
        this.map.clear();
    }
}

