/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public class INodeDirectoryWithQuota
extends INodeDirectory {
    private long nsQuota = Long.MAX_VALUE;
    private long namespace = 1L;
    private long dsQuota = -1L;
    private long diskspace = 0L;

    public INodeDirectoryWithQuota(INodeDirectory other, boolean adopt, long nsQuota, long dsQuota) {
        super(other, adopt);
        Quota.Counts counts = other.computeQuotaUsage();
        this.namespace = counts.get(Quota.NAMESPACE);
        this.diskspace = counts.get(Quota.DISKSPACE);
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
    }

    INodeDirectoryWithQuota(long id, byte[] name, PermissionStatus permissions, long modificationTime, long nsQuota, long dsQuota) {
        super(id, name, permissions, modificationTime);
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
    }

    INodeDirectoryWithQuota(long id, byte[] name, PermissionStatus permissions) {
        super(id, name, permissions, 0L);
    }

    @Override
    public long getNsQuota() {
        return this.nsQuota;
    }

    @Override
    public long getDsQuota() {
        return this.dsQuota;
    }

    public void setQuota(long nsQuota, long dsQuota) {
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
    }

    @Override
    public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        if (useCache && this.isQuotaSet()) {
            counts.add(Quota.NAMESPACE, this.namespace);
            counts.add(Quota.DISKSPACE, this.diskspace);
        } else {
            super.computeQuotaUsage(counts, false, lastSnapshotId);
        }
        return counts;
    }

    @Override
    public Content.Counts computeContentSummary(Content.Counts counts) {
        long original = counts.get(Content.DISKSPACE);
        super.computeContentSummary(counts);
        this.checkDiskspace(counts.get(Content.DISKSPACE) - original);
        return counts;
    }

    private void checkDiskspace(long computed) {
        if (-1L != this.getDsQuota() && this.diskspace != computed) {
            NameNode.LOG.error("BUG: Inconsistent diskspace for directory " + this.getFullPathName() + ". Cached = " + this.diskspace + " != Computed = " + computed);
        }
    }

    long numItemsInTree() {
        return this.namespace;
    }

    @Override
    public final void addSpaceConsumed(long nsDelta, long dsDelta, boolean verify2) throws QuotaExceededException {
        if (this.isQuotaSet()) {
            if (verify2) {
                this.verifyQuota(nsDelta, dsDelta);
            }
            super.addSpaceConsumed(nsDelta, dsDelta, verify2);
            this.addSpaceConsumed2Cache(nsDelta, dsDelta);
        } else {
            super.addSpaceConsumed(nsDelta, dsDelta, verify2);
        }
    }

    protected void addSpaceConsumed2Cache(long nsDelta, long dsDelta) {
        this.namespace += nsDelta;
        this.diskspace += dsDelta;
    }

    void setSpaceConsumed(long namespace, long diskspace) {
        this.namespace = namespace;
        this.diskspace = diskspace;
    }

    void verifyNamespaceQuota(long delta) throws NSQuotaExceededException {
        if (Quota.isViolated(this.nsQuota, this.namespace, delta)) {
            throw new NSQuotaExceededException(this.nsQuota, this.namespace + delta);
        }
    }

    void verifyQuota(long nsDelta, long dsDelta) throws QuotaExceededException {
        this.verifyNamespaceQuota(nsDelta);
        if (Quota.isViolated(this.dsQuota, this.diskspace, dsDelta)) {
            throw new DSQuotaExceededException(this.dsQuota, this.diskspace + dsDelta);
        }
    }

    String namespaceString() {
        return "namespace: " + (this.nsQuota < 0L ? "-" : this.namespace + "/" + this.nsQuota);
    }

    String diskspaceString() {
        return "diskspace: " + (this.dsQuota < 0L ? "-" : this.diskspace + "/" + this.dsQuota);
    }

    String quotaString() {
        return ", Quota[" + this.namespaceString() + ", " + this.diskspaceString() + "]";
    }

    @VisibleForTesting
    public long getNamespace() {
        return this.namespace;
    }

    @VisibleForTesting
    public long getDiskspace() {
        return this.diskspace;
    }
}

