/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.util.HostsFileReader;

public class HostFileManager {
    private static final Log LOG = LogFactory.getLog(HostFileManager.class);
    private EntrySet includes = new EntrySet();
    private EntrySet excludes = new EntrySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String includeFile, String excludeFile) throws IOException {
        MutableEntrySet newIncludes = new MutableEntrySet();
        IOException includeException = null;
        try {
            newIncludes.readFile("included", includeFile);
        }
        catch (IOException e) {
            includeException = e;
        }
        MutableEntrySet newExcludes = new MutableEntrySet();
        IOException excludeException = null;
        try {
            newExcludes.readFile("excluded", excludeFile);
        }
        catch (IOException e) {
            excludeException = e;
        }
        HostFileManager hostFileManager = this;
        synchronized (hostFileManager) {
            if (includeException == null) {
                this.includes = newIncludes;
            }
            if (excludeException == null) {
                this.excludes = newExcludes;
            }
        }
        if (includeException == null) {
            LOG.info("read includes:\n" + newIncludes);
        } else {
            LOG.error("failed to read include file '" + includeFile + "'. " + "Continuing to use previous include list.", includeException);
        }
        if (excludeException == null) {
            LOG.info("read excludes:\n" + newExcludes);
        } else {
            LOG.error("failed to read exclude file '" + excludeFile + "'." + "Continuing to use previous exclude list.", excludeException);
        }
        if (includeException != null) {
            throw new IOException("error reading hosts file " + includeFile, includeException);
        }
        if (excludeException != null) {
            throw new IOException("error reading exclude file " + excludeFile, excludeException);
        }
    }

    public synchronized boolean isIncluded(DatanodeID dn) {
        if (this.includes.isEmpty()) {
            return true;
        }
        return this.includes.find(dn) != null;
    }

    public synchronized boolean isExcluded(DatanodeID dn) {
        return this.excludes.find(dn) != null;
    }

    public synchronized boolean hasIncludes() {
        return !this.includes.isEmpty();
    }

    public synchronized EntrySet getIncludes() {
        return this.includes;
    }

    public synchronized EntrySet getExcludes() {
        return this.excludes;
    }

    public static class MutableEntrySet
    extends EntrySet {
        public void add(DatanodeID datanodeID) {
            Entry entry2 = new Entry(datanodeID.getHostName(), datanodeID.getXferPort(), datanodeID.getIpAddr());
            this.index.put(datanodeID.getIpAddr() + ":" + datanodeID.getXferPort(), entry2);
        }

        public void add(Entry entry2) {
            int port = entry2.getPort();
            if (port != 0) {
                this.index.put(entry2.getIdentifier() + ":" + port, entry2);
            } else {
                this.index.put(entry2.getIdentifier(), entry2);
            }
        }

        void readFile(String type, String filename) throws IOException {
            if (filename.isEmpty()) {
                return;
            }
            HashSet<String> entrySet = new HashSet<String>();
            HostsFileReader.readFileToSet(type, filename, entrySet);
            for (String str : entrySet) {
                Entry entry2 = Entry.parse(filename, str);
                this.add(entry2);
            }
        }
    }

    public static class EntrySet
    implements Iterable<Entry> {
        TreeMap<String, Entry> index = new TreeMap();

        public boolean isEmpty() {
            return this.index.isEmpty();
        }

        public Entry find(DatanodeID datanodeID) {
            String registeredHostName;
            Entry entry2;
            int xferPort = datanodeID.getXferPort();
            assert (xferPort > 0);
            String datanodeIpAddr = datanodeID.getIpAddr();
            if (datanodeIpAddr != null) {
                entry2 = this.index.get(datanodeIpAddr + ":" + xferPort);
                if (entry2 != null) {
                    return entry2;
                }
                entry2 = this.index.get(datanodeIpAddr);
                if (entry2 != null) {
                    return entry2;
                }
            }
            if ((registeredHostName = datanodeID.getHostName()) != null) {
                entry2 = this.index.get(registeredHostName + ":" + xferPort);
                if (entry2 != null) {
                    return entry2;
                }
                entry2 = this.index.get(registeredHostName);
                if (entry2 != null) {
                    return entry2;
                }
            }
            return null;
        }

        public Entry find(Entry toFind) {
            int port = toFind.getPort();
            if (port != 0) {
                return this.index.get(toFind.getIdentifier() + ":" + port);
            }
            Map.Entry<String, Entry> ceil = this.index.ceilingEntry(toFind.getIdentifier());
            if (ceil != null && ceil.getValue().getIdentifier().equals(toFind.getIdentifier())) {
                return ceil.getValue();
            }
            return null;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("HostSet(");
            for (Map.Entry<String, Entry> entry2 : this.index.entrySet()) {
                bld.append("\n\t");
                bld.append(entry2.getKey()).append("->").append(entry2.getValue().toString());
            }
            bld.append("\n)");
            return bld.toString();
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.index.values().iterator();
        }
    }

    public static class Entry {
        private final String prefix;
        private final int port;
        private final String ipAddress;

        static Entry parse(String fileName, String entry2) throws IOException {
            int port;
            String prefix;
            String ipAddress = "";
            int idx = entry2.indexOf(58);
            if (-1 == idx) {
                prefix = entry2;
                port = 0;
            } else {
                prefix = entry2.substring(0, idx);
                String portStr = entry2.substring(idx + 1);
                try {
                    port = Integer.valueOf(portStr);
                }
                catch (NumberFormatException e) {
                    throw new IOException("unable to parse port number for '" + entry2 + "'", e);
                }
            }
            try {
                InetAddress addr = InetAddress.getByName(prefix);
                ipAddress = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.info("When reading " + fileName + ", could not look up " + "IP address for " + prefix + ".  We will assume this is a " + "registration name.", e);
            }
            return new Entry(prefix, port, ipAddress);
        }

        public String getIdentifier() {
            return this.ipAddress.isEmpty() ? this.prefix : this.ipAddress;
        }

        public Entry(String prefix, int port, String ipAddress) {
            this.prefix = prefix;
            this.port = port;
            this.ipAddress = ipAddress;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getPort() {
            return this.port;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("Entry{").append(this.prefix).append(", port=").append(this.port).append(", ipAddress=").append(this.ipAddress).append("}");
            return bld.toString();
        }
    }
}

