/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LDir;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;

class BlockPoolSlice {
    private final String bpid;
    private final FsVolumeImpl volume;
    private final File currentDir;
    private final LDir finalizedDir;
    private final File rbwDir;
    private final File tmpDir;
    private final DU dfsUsage;

    BlockPoolSlice(String bpid, FsVolumeImpl volume, File bpDir, Configuration conf) throws IOException {
        this.bpid = bpid;
        this.volume = volume;
        this.currentDir = new File(bpDir, "current");
        File finalizedDir = new File(this.currentDir, "finalized");
        this.tmpDir = new File(bpDir, "tmp");
        if (this.tmpDir.exists()) {
            FileUtil.fullyDelete(this.tmpDir);
        }
        this.rbwDir = new File(this.currentDir, "rbw");
        boolean supportAppends = conf.getBoolean("dfs.support.append", true);
        if (this.rbwDir.exists() && !supportAppends) {
            FileUtil.fullyDelete(this.rbwDir);
        }
        int maxBlocksPerDir = conf.getInt("dfs.datanode.numblocks", 64);
        this.finalizedDir = new LDir(finalizedDir, maxBlocksPerDir);
        if (!this.rbwDir.mkdirs() && !this.rbwDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.rbwDir.toString());
        }
        if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
        }
        this.dfsUsage = new DU(bpDir, conf);
        this.dfsUsage.start();
    }

    File getDirectory() {
        return this.currentDir.getParentFile();
    }

    File getFinalizedDir() {
        return this.finalizedDir.dir;
    }

    File getRbwDir() {
        return this.rbwDir;
    }

    void decDfsUsed(long value2) {
        this.dfsUsage.decDfsUsed(value2);
    }

    long getDfsUsed() throws IOException {
        return this.dfsUsage.getUsed();
    }

    File createTmpFile(Block b) throws IOException {
        File f = new File(this.tmpDir, b.getBlockName());
        return DatanodeUtil.createTmpFile(b, f);
    }

    File createRbwFile(Block b) throws IOException {
        File f = new File(this.rbwDir, b.getBlockName());
        return DatanodeUtil.createTmpFile(b, f);
    }

    File addBlock(Block b, File f) throws IOException {
        File blockFile = this.finalizedDir.addBlock(b, f);
        File metaFile = FsDatasetUtil.getMetaFile(blockFile, b.getGenerationStamp());
        this.dfsUsage.incDfsUsed(b.getNumBytes() + metaFile.length());
        return blockFile;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        this.finalizedDir.checkDirTree();
        DiskChecker.checkDir(this.tmpDir);
        DiskChecker.checkDir(this.rbwDir);
    }

    void getVolumeMap(ReplicaMap volumeMap) throws IOException {
        this.finalizedDir.getVolumeMap(this.bpid, volumeMap, this.volume);
        this.addToReplicasMap(volumeMap, this.rbwDir, false);
    }

    void addToReplicasMap(ReplicaMap volumeMap, File dir, boolean isFinalized) throws IOException {
        File[] blockFiles;
        for (File blockFile : blockFiles = FileUtil.listFiles(dir)) {
            if (!Block.isBlockFilename(blockFile)) continue;
            long genStamp = FsDatasetUtil.getGenerationStampFromFile(blockFiles, blockFile);
            long blockId = Block.filename2id(blockFile.getName());
            ReplicaInfo newReplica = null;
            newReplica = isFinalized ? new FinalizedReplica(blockId, blockFile.length(), genStamp, this.volume, blockFile.getParentFile()) : new ReplicaWaitingToBeRecovered(blockId, this.validateIntegrity(blockFile, genStamp), genStamp, this.volume, blockFile.getParentFile());
            ReplicaInfo oldReplica = volumeMap.add(this.bpid, newReplica);
            if (oldReplica == null) continue;
            FsDatasetImpl.LOG.warn("Two block files with the same block id exist on disk: " + oldReplica.getBlockFile() + " and " + blockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long validateIntegrity(File blockFile, long genStamp) {
        long l;
        FileInputStream blockIn;
        DataInputStream checksumIn;
        block14: {
            long l2;
            block13: {
                long l3;
                block12: {
                    checksumIn = null;
                    blockIn = null;
                    try {
                        int checksumSize;
                        DataChecksum checksum;
                        int bytesPerChecksum;
                        long numChunks;
                        File metaFile = FsDatasetUtil.getMetaFile(blockFile, genStamp);
                        long blockFileLen = blockFile.length();
                        long metaFileLen = metaFile.length();
                        int crcHeaderLen = DataChecksum.getChecksumHeaderSize();
                        if (!blockFile.exists() || blockFileLen == 0L || !metaFile.exists() || metaFileLen < (long)crcHeaderLen) {
                            long l4 = 0L;
                            return l4;
                        }
                        checksumIn = new DataInputStream(new BufferedInputStream(new FileInputStream(metaFile), HdfsConstants.IO_FILE_BUFFER_SIZE));
                        BlockMetadataHeader header = BlockMetadataHeader.readHeader(checksumIn);
                        short version = header.getVersion();
                        if (version != 1) {
                            FsDatasetImpl.LOG.warn("Wrong version (" + version + ") for metadata file " + metaFile + " ignoring ...");
                        }
                        if ((numChunks = Math.min((blockFileLen + (long)(bytesPerChecksum = (checksum = header.getChecksum()).getBytesPerChecksum()) - 1L) / (long)bytesPerChecksum, (metaFileLen - (long)crcHeaderLen) / (long)(checksumSize = checksum.getChecksumSize()))) == 0L) {
                            l3 = 0L;
                            IOUtils.closeStream(checksumIn);
                            break block12;
                        }
                        IOUtils.skipFully(checksumIn, (numChunks - 1L) * (long)checksumSize);
                        blockIn = new FileInputStream(blockFile);
                        long lastChunkStartPos = (numChunks - 1L) * (long)bytesPerChecksum;
                        IOUtils.skipFully(blockIn, lastChunkStartPos);
                        int lastChunkSize = (int)Math.min((long)bytesPerChecksum, blockFileLen - lastChunkStartPos);
                        byte[] buf = new byte[lastChunkSize + checksumSize];
                        checksumIn.readFully(buf, lastChunkSize, checksumSize);
                        IOUtils.readFully(blockIn, buf, 0, lastChunkSize);
                        checksum.update(buf, 0, lastChunkSize);
                        if (checksum.compare(buf, lastChunkSize)) {
                            l2 = lastChunkStartPos + (long)lastChunkSize;
                            IOUtils.closeStream(checksumIn);
                            break block13;
                        }
                        l = lastChunkStartPos;
                        IOUtils.closeStream(checksumIn);
                        break block14;
                    }
                    catch (IOException e) {
                        FsDatasetImpl.LOG.warn(e);
                        long l5 = 0L;
                        return l5;
                    }
                }
                IOUtils.closeStream(blockIn);
                return l3;
            }
            IOUtils.closeStream(blockIn);
            return l2;
        }
        IOUtils.closeStream(blockIn);
        return l;
        finally {
            IOUtils.closeStream(checksumIn);
            IOUtils.closeStream(blockIn);
        }
    }

    void clearPath(File f) {
        this.finalizedDir.clearPath(f);
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown() {
        this.dfsUsage.shutdown();
    }
}

