/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public abstract class ReplicaInfo
extends Block
implements Replica {
    private FsVolumeSpi volume;
    private File baseDir;
    private int[] subDirs;
    private static final Map<String, File> internedBaseDirs = new HashMap<String, File>();

    ReplicaInfo(long blockId, long genStamp, FsVolumeSpi vol, File dir) {
        this(blockId, 0L, genStamp, vol, dir);
    }

    ReplicaInfo(Block block, FsVolumeSpi vol, File dir) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir);
    }

    ReplicaInfo(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir) {
        super(blockId, len, genStamp);
        this.volume = vol;
        this.setDirInternal(dir);
    }

    ReplicaInfo(ReplicaInfo from2) {
        this(from2, from2.getVolume(), from2.getDir());
    }

    public File getBlockFile() {
        return new File(this.getDir(), this.getBlockName());
    }

    public File getMetaFile() {
        return new File(this.getDir(), DatanodeUtil.getMetaName(this.getBlockName(), this.getGenerationStamp()));
    }

    public FsVolumeSpi getVolume() {
        return this.volume;
    }

    void setVolume(FsVolumeSpi vol) {
        this.volume = vol;
    }

    File getDir() {
        if (this.subDirs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i : this.subDirs) {
            sb.append("subdir");
            sb.append(i);
            sb.append("/");
        }
        File ret = new File(this.baseDir, sb.toString());
        return ret;
    }

    public void setDir(File dir) {
        this.setDirInternal(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirInternal(File dir) {
        if (dir == null) {
            this.subDirs = null;
            this.baseDir = null;
            return;
        }
        ReplicaDirInfo replicaDirInfo = ReplicaInfo.parseSubDirs(dir);
        this.subDirs = replicaDirInfo.subDirs;
        Map<String, File> map2 = internedBaseDirs;
        synchronized (map2) {
            if (!internedBaseDirs.containsKey(replicaDirInfo.baseDirPath)) {
                File baseDir = new File(new String(replicaDirInfo.baseDirPath));
                internedBaseDirs.put(replicaDirInfo.baseDirPath, baseDir);
            }
            this.baseDir = internedBaseDirs.get(replicaDirInfo.baseDirPath);
        }
    }

    @VisibleForTesting
    public static ReplicaDirInfo parseSubDirs(File dir) {
        ReplicaDirInfo ret = new ReplicaDirInfo();
        File currentDir = dir;
        ArrayList<Integer> subDirList = new ArrayList<Integer>();
        while (currentDir.getName().startsWith("subdir")) {
            subDirList.add(0, Integer.parseInt(currentDir.getName().replaceFirst("subdir", "")));
            currentDir = currentDir.getParentFile();
        }
        ret.subDirs = new int[subDirList.size()];
        for (int i = 0; i < subDirList.size(); ++i) {
            ret.subDirs[i] = (Integer)subDirList.get(i);
        }
        ret.baseDirPath = currentDir.getAbsolutePath();
        return ret;
    }

    public boolean isUnlinked() {
        return true;
    }

    public void setUnlinked() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlinkFile(File file, Block b) throws IOException {
        File tmpFile = DatanodeUtil.createTmpFile(b, DatanodeUtil.getUnlinkTmpFile(file));
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, 16384);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            if (file.length() != tmpFile.length()) {
                throw new IOException("Copy of file " + file + " size " + file.length() + " into file " + tmpFile + " resulted in a size of " + tmpFile.length());
            }
            FileUtil.replaceFile(tmpFile, file);
        }
        catch (IOException e) {
            boolean done = tmpFile.delete();
            if (!done) {
                DataNode.LOG.info("detachFile failed to delete temporary file " + tmpFile);
            }
            throw e;
        }
    }

    public boolean unlinkBlock(int numLinks) throws IOException {
        if (this.isUnlinked()) {
            return false;
        }
        File file = this.getBlockFile();
        if (file == null || this.getVolume() == null) {
            throw new IOException("detachBlock:Block not found. " + this);
        }
        File meta = this.getMetaFile();
        if (HardLink.getLinkCount(file) > numLinks) {
            DataNode.LOG.info("CopyOnWrite for block " + this);
            this.unlinkFile(file, this);
        }
        if (HardLink.getLinkCount(meta) > numLinks) {
            this.unlinkFile(meta, this);
        }
        this.setUnlinked();
        return true;
    }

    void setNewerGenerationStamp(long newGS) throws IOException {
        long curGS = this.getGenerationStamp();
        if (newGS <= curGS) {
            throw new IOException("New generation stamp (" + newGS + ") must be greater than current one (" + curGS + ")");
        }
        this.setGenerationStamp(newGS);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ", " + super.toString() + ", " + (Object)((Object)this.getState()) + "\n  getNumBytes()     = " + this.getNumBytes() + "\n  getBytesOnDisk()  = " + this.getBytesOnDisk() + "\n  getVisibleLength()= " + this.getVisibleLength() + "\n  getVolume()       = " + this.getVolume() + "\n  getBlockFile()    = " + this.getBlockFile();
    }

    @VisibleForTesting
    public static class ReplicaDirInfo {
        @VisibleForTesting
        public String baseDirPath;
        @VisibleForTesting
        public int[] subDirs;
    }
}

