/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
class BlockPoolManager {
    private static final Log LOG = DataNode.LOG;
    private final Map<String, BPOfferService> bpByNameserviceId = Maps.newHashMap();
    private final Map<String, BPOfferService> bpByBlockPoolId = Maps.newHashMap();
    private final List<BPOfferService> offerServices = Lists.newArrayList();
    private final DataNode dn;
    private final Object refreshNamenodesLock = new Object();

    BlockPoolManager(DataNode dn) {
        this.dn = dn;
    }

    synchronized void addBlockPool(BPOfferService bpos) {
        Preconditions.checkArgument(this.offerServices.contains(bpos), "Unknown BPOS: %s", bpos);
        if (bpos.getBlockPoolId() == null) {
            throw new IllegalArgumentException("Null blockpool id");
        }
        this.bpByBlockPoolId.put(bpos.getBlockPoolId(), bpos);
    }

    synchronized BPOfferService[] getAllNamenodeThreads() {
        BPOfferService[] bposArray = new BPOfferService[this.offerServices.size()];
        return this.offerServices.toArray(bposArray);
    }

    synchronized BPOfferService get(String bpid) {
        return this.bpByBlockPoolId.get(bpid);
    }

    synchronized void remove(BPOfferService t) {
        this.offerServices.remove(t);
        this.bpByBlockPoolId.remove(t.getBlockPoolId());
        boolean removed = false;
        Iterator<BPOfferService> it = this.bpByNameserviceId.values().iterator();
        while (it.hasNext() && !removed) {
            BPOfferService bpos = it.next();
            if (bpos != t) continue;
            it.remove();
            LOG.info("Removed " + bpos);
            removed = true;
        }
        if (!removed) {
            LOG.warn("Couldn't remove BPOS " + t + " from bpByNameserviceId map");
        }
    }

    void shutDownAll(BPOfferService[] bposArray) throws InterruptedException {
        if (bposArray != null) {
            for (BPOfferService bpos : bposArray) {
                bpos.stop();
            }
            for (BPOfferService bpos : bposArray) {
                bpos.join();
            }
        }
    }

    synchronized void startAll() throws IOException {
        try {
            UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    for (BPOfferService bpos : BlockPoolManager.this.offerServices) {
                        bpos.start();
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex.getCause());
            throw ioe;
        }
    }

    void joinAll() {
        for (BPOfferService bpos : this.getAllNamenodeThreads()) {
            bpos.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshNamenodes(Configuration conf) throws IOException {
        LOG.info("Refresh request received for nameservices: " + conf.get("dfs.nameservices"));
        Map<String, Map<String, InetSocketAddress>> newAddressMap = DFSUtil.getNNServiceRpcAddresses(conf);
        Object object = this.refreshNamenodesLock;
        synchronized (object) {
            this.doRefreshNamenodes(newAddressMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshNamenodes(Map<String, Map<String, InetSocketAddress>> addrMap) throws IOException {
        BPOfferService bpos;
        ArrayList<InetSocketAddress> addrs;
        HashSet<String> toRemove;
        assert (Thread.holdsLock(this.refreshNamenodesLock));
        LinkedHashSet<String> toRefresh = Sets.newLinkedHashSet();
        LinkedHashSet<String> toAdd = Sets.newLinkedHashSet();
        BlockPoolManager blockPoolManager = this;
        synchronized (blockPoolManager) {
            for (String nameserviceId : addrMap.keySet()) {
                if (this.bpByNameserviceId.containsKey(nameserviceId)) {
                    toRefresh.add(nameserviceId);
                    continue;
                }
                toAdd.add(nameserviceId);
            }
            toRemove = Sets.newHashSet(Sets.difference(this.bpByNameserviceId.keySet(), addrMap.keySet()));
            assert (toRefresh.size() + toAdd.size() == addrMap.size()) : "toAdd: " + Joiner.on(",").useForNull("<default>").join(toAdd) + "  toRemove: " + Joiner.on(",").useForNull("<default>").join(toRemove) + "  toRefresh: " + Joiner.on(",").useForNull("<default>").join(toRefresh);
            if (!toAdd.isEmpty()) {
                LOG.info("Starting BPOfferServices for nameservices: " + Joiner.on(",").useForNull("<default>").join(toAdd));
                for (String nsToAdd : toAdd) {
                    addrs = Lists.newArrayList(addrMap.get(nsToAdd).values());
                    BPOfferService bpos2 = this.createBPOS(addrs);
                    this.bpByNameserviceId.put(nsToAdd, bpos2);
                    this.offerServices.add(bpos2);
                }
            }
            this.startAll();
        }
        if (!toRemove.isEmpty()) {
            LOG.info("Stopping BPOfferServices for nameservices: " + Joiner.on(",").useForNull("<default>").join(toRemove));
            for (String nsToRemove : toRemove) {
                bpos = this.bpByNameserviceId.get(nsToRemove);
                bpos.stop();
                bpos.join();
            }
        }
        if (!toRefresh.isEmpty()) {
            LOG.info("Refreshing list of NNs for nameservices: " + Joiner.on(",").useForNull("<default>").join(toRefresh));
            for (String nsToRefresh : toRefresh) {
                bpos = this.bpByNameserviceId.get(nsToRefresh);
                addrs = Lists.newArrayList(addrMap.get(nsToRefresh).values());
                bpos.refreshNNList(addrs);
            }
        }
    }

    protected BPOfferService createBPOS(List<InetSocketAddress> nnAddrs) {
        return new BPOfferService(nnAddrs, this.dn);
    }
}

