/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

@InterfaceAudience.Private
public class ZkAclReset
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ZkAclReset.class);
    private static final int ZK_SESSION_TIMEOUT_DEFAULT = 5000;

    private static void resetAcls(ZooKeeper zk, String znode) throws Exception {
        List<String> children = zk.getChildren(znode, false);
        if (children != null) {
            for (String child : children) {
                ZkAclReset.resetAcls(zk, znode + '/' + child);
            }
        }
        LOG.info(" - reset acl for " + znode);
        zk.setACL(znode, ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetAcls(String quorumServers, int zkTimeout, String znode) throws Exception {
        ZooKeeper zk = new ZooKeeper(quorumServers, zkTimeout, new ZkWatcher());
        try {
            ZkAclReset.resetAcls(zk, znode);
        }
        finally {
            zk.close();
        }
    }

    private void resetHBaseAcls(Configuration conf) throws Exception {
        String quorumServers = conf.get("hbase.zookeeper.quorum", "localhost");
        int sessionTimeout = conf.getInt("zookeeper.session.timeout", 5000);
        String znode = conf.get("zookeeper.znode.parent", "/hbase");
        if (quorumServers == null) {
            LOG.error("Unable to load hbase.zookeeper.quorum (try with: -conf hbase-site.xml)");
            return;
        }
        LOG.info("Reset HBase ACLs for " + quorumServers + " " + znode);
        ZkAclReset.resetAcls(quorumServers, sessionTimeout, znode);
    }

    @Override
    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        this.resetHBaseAcls(conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run(new Configuration(), new ZkAclReset(), args));
    }

    private static class ZkWatcher
    implements Watcher {
        @Override
        public void process(WatchedEvent event) {
            LOG.info("Received ZooKeeper Event, type=" + (Object)((Object)event.getType()) + ", " + "state=" + (Object)((Object)event.getState()) + ", " + "path=" + event.getPath());
        }
    }
}

