/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ZKSplitLog {
    private static final Log LOG = LogFactory.getLog(ZKSplitLog.class);

    public static String getEncodedNodeName(ZooKeeperWatcher zkw, String filename) {
        return ZKUtil.joinZNode(zkw.splitLogZNode, ZKSplitLog.encode(filename));
    }

    public static String getFileName(String node) {
        String basename = node.substring(node.lastIndexOf(47) + 1);
        return ZKSplitLog.decode(basename);
    }

    static String encode(String s2) {
        try {
            return URLEncoder.encode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLENCODER doesn't support UTF-8");
        }
    }

    static String decode(String s2) {
        try {
            return URLDecoder.decode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLDecoder doesn't support UTF-8");
        }
    }

    public static String getRescanNode(ZooKeeperWatcher zkw) {
        return ZKUtil.joinZNode(zkw.splitLogZNode, "RESCAN");
    }

    public static boolean isRescanNode(String name) {
        return name.startsWith("RESCAN");
    }

    public static boolean isRescanNode(ZooKeeperWatcher zkw, String path) {
        String prefix = ZKSplitLog.getRescanNode(zkw);
        if (path.length() <= prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == path.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTaskPath(ZooKeeperWatcher zkw, String path) {
        String dirname = path.substring(0, path.lastIndexOf(47));
        return dirname.equals(zkw.splitLogZNode);
    }

    public static Path getSplitLogDir(Path rootdir, String tmpname) {
        return new Path(new Path(rootdir, "splitWAL"), tmpname);
    }

    public static String getSplitLogDirTmpComponent(String worker, String file) {
        return worker + "_" + ZKSplitLog.encode(file);
    }

    public static void markCorrupted(Path rootdir, String logFileName, FileSystem fs) {
        Path file = new Path(ZKSplitLog.getSplitLogDir(rootdir, logFileName), "corrupt");
        try {
            fs.createNewFile(file);
        }
        catch (IOException e) {
            LOG.warn("Could not flag a log file as corrupted. Failed to create " + file, e);
        }
    }

    public static boolean isCorrupted(Path rootdir, String logFileName, FileSystem fs) throws IOException {
        Path file = new Path(ZKSplitLog.getSplitLogDir(rootdir, logFileName), "corrupt");
        boolean isCorrupt = fs.exists(file);
        return isCorrupt;
    }
}

