/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@Deprecated
@InterfaceAudience.Private
public class ZKLeaderManager
extends ZooKeeperListener {
    private static Log LOG = LogFactory.getLog(ZKLeaderManager.class);
    private final AtomicBoolean leaderExists = new AtomicBoolean();
    private String leaderZNode;
    private byte[] nodeId;
    private Stoppable candidate;

    public ZKLeaderManager(ZooKeeperWatcher watcher, String leaderZNode, byte[] identifier, Stoppable candidate) {
        super(watcher);
        this.leaderZNode = leaderZNode;
        this.nodeId = identifier;
        this.candidate = candidate;
    }

    public void start() {
        try {
            this.watcher.registerListener(this);
            String parent = ZKUtil.getParent(this.leaderZNode);
            if (ZKUtil.checkExists(this.watcher, parent) < 0) {
                ZKUtil.createWithParents(this.watcher, parent);
            }
        }
        catch (KeeperException ke) {
            this.watcher.abort("Unhandled zk exception when starting", ke);
            this.candidate.stop("Unhandled zk exception starting up: " + ke.getMessage());
        }
    }

    @Override
    public void nodeCreated(String path) {
        if (this.leaderZNode.equals(path) && !this.candidate.isStopped()) {
            this.handleLeaderChange();
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (this.leaderZNode.equals(path) && !this.candidate.isStopped()) {
            this.handleLeaderChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLeaderChange() {
        try {
            AtomicBoolean atomicBoolean = this.leaderExists;
            synchronized (atomicBoolean) {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.leaderZNode)) {
                    LOG.info("Found new leader for znode: " + this.leaderZNode);
                    this.leaderExists.set(true);
                } else {
                    LOG.info("Leader change, but no new leader found");
                    this.leaderExists.set(false);
                    this.leaderExists.notifyAll();
                }
            }
        }
        catch (KeeperException ke) {
            this.watcher.abort("ZooKeeper error checking for leader znode", ke);
            this.candidate.stop("ZooKeeper error checking for leader: " + ke.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBecomeLeader() {
        while (!this.candidate.isStopped()) {
            try {
                if (ZKUtil.createEphemeralNodeAndWatch(this.watcher, this.leaderZNode, this.nodeId)) {
                    this.leaderExists.set(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Claimed the leader znode as '" + Bytes.toStringBinary(this.nodeId) + "'");
                    }
                    return;
                }
                byte[] currentId = ZKUtil.getDataAndWatch(this.watcher, this.leaderZNode);
                if (currentId != null && Bytes.equals(currentId, this.nodeId)) {
                    LOG.info("Found existing leader with our ID (" + Bytes.toStringBinary(this.nodeId) + "), removing");
                    ZKUtil.deleteNode(this.watcher, this.leaderZNode);
                    this.leaderExists.set(false);
                } else {
                    LOG.info("Found existing leader with ID: " + Bytes.toStringBinary(this.nodeId));
                    this.leaderExists.set(true);
                }
            }
            catch (KeeperException ke) {
                this.watcher.abort("Unexpected error from ZK, stopping candidate", ke);
                this.candidate.stop("Unexpected error from ZK: " + ke.getMessage());
                return;
            }
            AtomicBoolean atomicBoolean = this.leaderExists;
            synchronized (atomicBoolean) {
                while (this.leaderExists.get() && !this.candidate.isStopped()) {
                    try {
                        this.leaderExists.wait();
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Interrupted waiting on leader", ie);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepDownAsLeader() {
        try {
            AtomicBoolean atomicBoolean = this.leaderExists;
            synchronized (atomicBoolean) {
                if (!this.leaderExists.get()) {
                    return;
                }
                byte[] leaderId = ZKUtil.getData(this.watcher, this.leaderZNode);
                if (leaderId != null && Bytes.equals(this.nodeId, leaderId)) {
                    LOG.info("Stepping down as leader");
                    ZKUtil.deleteNodeFailSilent(this.watcher, this.leaderZNode);
                    this.leaderExists.set(false);
                } else {
                    LOG.info("Not current leader, no need to step down");
                }
            }
        }
        catch (KeeperException ke) {
            this.watcher.abort("Unhandled zookeeper exception removing leader node", ke);
            this.candidate.stop("Unhandled zookeeper exception removing leader node: " + ke.getMessage());
        }
    }

    public boolean hasLeader() {
        return this.leaderExists.get();
    }
}

