/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class MasterAddressTracker
extends ZooKeeperNodeTracker {
    public MasterAddressTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getMasterAddressZNode(), abortable);
    }

    public ServerName getMasterAddress() {
        return this.getMasterAddress(false);
    }

    public ServerName getMasterAddress(boolean refresh) {
        try {
            return ServerName.parseFrom(super.getData(refresh));
        }
        catch (DeserializationException e) {
            LOG.warn("Failed parse", e);
            return null;
        }
    }

    public static ServerName getMasterAddress(ZooKeeperWatcher zkw) throws KeeperException, IOException {
        byte[] data2 = ZKUtil.getData(zkw, zkw.getMasterAddressZNode());
        if (data2 == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return ServerName.parseFrom(data2);
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause(e);
            throw ke;
        }
    }

    public static boolean setMasterAddress(ZooKeeperWatcher zkw, String znode, ServerName master) throws KeeperException {
        return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, MasterAddressTracker.toByteArray(master));
    }

    public boolean hasMaster() {
        return super.getData(false) != null;
    }

    static byte[] toByteArray(ServerName sn) {
        ZooKeeperProtos.Master.Builder mbuilder = ZooKeeperProtos.Master.newBuilder();
        HBaseProtos.ServerName.Builder snbuilder = HBaseProtos.ServerName.newBuilder();
        snbuilder.setHostName(sn.getHostname());
        snbuilder.setPort(sn.getPort());
        snbuilder.setStartCode(sn.getStartcode());
        mbuilder.setMaster(snbuilder.build());
        mbuilder.setRpcVersion(0);
        return ProtobufUtil.prependPBMagic(mbuilder.build().toByteArray());
    }

    public static boolean deleteIfEquals(ZooKeeperWatcher zkw, String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        try {
            Stat stat = new Stat();
            byte[] data2 = ZKUtil.getDataNoWatch(zkw, zkw.getMasterAddressZNode(), stat);
            ServerName sn = ServerName.parseFrom(data2);
            if (sn != null && content.equals(sn.toString())) {
                return ZKUtil.deleteNode(zkw, zkw.getMasterAddressZNode(), stat.getVersion());
            }
        }
        catch (KeeperException e) {
            LOG.warn("Can't get or delete the master znode", e);
        }
        catch (DeserializationException e) {
            LOG.warn("Can't get or delete the master znode", e);
        }
        return false;
    }
}

