/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.vint;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class UVLongTool {
    public static final byte BYTE_7_RIGHT_BITS_SET = 127;
    public static final byte BYTE_LEFT_BIT_SET = -128;
    public static final long LONG_7_RIGHT_BITS_SET = 127L;
    public static final long LONG_8TH_BIT_SET = 128L;
    public static final byte[] MAX_VALUE_BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};

    public static int numBytes(long in) {
        if (in == 0L) {
            return 1;
        }
        return (70 - Long.numberOfLeadingZeros(in)) / 7;
    }

    public static byte[] getBytes(long value2) {
        int numBytes = UVLongTool.numBytes(value2);
        byte[] bytes = new byte[numBytes];
        long remainder = value2;
        for (int i = 0; i < numBytes - 1; ++i) {
            bytes[i] = (byte)(remainder & 0x7FL | 0x80L);
            remainder >>= 7;
        }
        bytes[numBytes - 1] = (byte)(remainder & 0x7FL);
        return bytes;
    }

    public static int writeBytes(long value2, OutputStream os) throws IOException {
        int numBytes = UVLongTool.numBytes(value2);
        long remainder = value2;
        for (int i = 0; i < numBytes - 1; ++i) {
            os.write((byte)(remainder & 0x7FL | 0x80L));
            remainder >>= 7;
        }
        os.write((byte)(remainder & 0x7FL));
        return numBytes;
    }

    public static long getLong(byte[] bytes) {
        return UVLongTool.getLong(bytes, 0);
    }

    public static long getLong(byte[] bytes, int offset) {
        long value2 = 0L;
        int i = 0;
        while (true) {
            byte b = bytes[offset + i];
            long shifted = 0x7F & b;
            value2 |= (shifted <<= 7 * i);
            if (b >= 0) break;
            ++i;
        }
        return value2;
    }

    public static long getLong(InputStream is) throws IOException {
        int b;
        long value2 = 0L;
        int i = 0;
        do {
            b = is.read();
            long shifted = 0x7F & b;
            value2 |= (shifted <<= 7 * i);
            ++i;
        } while (b > 127);
        return value2;
    }
}

