/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class TableLockChecker {
    private ZooKeeperWatcher zkWatcher;
    private HBaseFsck.ErrorReporter errorReporter;
    long expireTimeout;

    public TableLockChecker(ZooKeeperWatcher zkWatcher, HBaseFsck.ErrorReporter errorReporter) {
        this.zkWatcher = zkWatcher;
        this.errorReporter = errorReporter;
        this.expireTimeout = zkWatcher.getConfiguration().getLong("hbase.table.lock.expire.ms", 600000L);
    }

    public void checkTableLocks() throws IOException {
        TableLockManager tableLockManager = TableLockManager.createTableLockManager(this.zkWatcher.getConfiguration(), this.zkWatcher, null);
        final long expireDate = EnvironmentEdgeManager.currentTimeMillis() - this.expireTimeout;
        InterProcessLock.MetadataHandler handler = new InterProcessLock.MetadataHandler(){

            @Override
            public void handleMetadata(byte[] ownerMetadata) {
                ZooKeeperProtos.TableLock data2 = TableLockManager.fromBytes(ownerMetadata);
                String msg = "Table lock acquire attempt found:";
                if (data2 != null) {
                    msg = msg + String.format("[tableName=%s:%s, lockOwner=%s, threadId=%s, purpose=%s, isShared=%s, createTime=%s]", data2.getTableName().getNamespace().toStringUtf8(), data2.getTableName().getQualifier().toStringUtf8(), ProtobufUtil.toServerName(data2.getLockOwner()), data2.getThreadId(), data2.getPurpose(), data2.getIsShared(), data2.getCreateTime());
                }
                if (data2 != null && data2.hasCreateTime() && data2.getCreateTime() < expireDate) {
                    TableLockChecker.this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.EXPIRED_TABLE_LOCK, msg);
                } else {
                    TableLockChecker.this.errorReporter.print(msg);
                }
            }
        };
        tableLockManager.visitAllLocks(handler);
    }

    public void fixExpiredTableLocks() throws IOException {
        TableLockManager tableLockManager = TableLockManager.createTableLockManager(this.zkWatcher.getConfiguration(), this.zkWatcher, null);
        tableLockManager.reapAllExpiredLocks();
    }
}

