/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class Writables {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Writable w) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            w.write(out);
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static byte[] getBytes(Writable ... ws) throws IOException {
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        int size2 = 0;
        for (Writable w : ws) {
            byte[] b = Writables.getBytes(w);
            size2 += b.length;
            bytes.add(b);
        }
        byte[] result2 = new byte[size2];
        int offset = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, result2, offset, b.length);
            offset += b.length;
        }
        return result2;
    }

    public static Writable getWritable(byte[] bytes, Writable w) throws IOException {
        return Writables.getWritable(bytes, 0, bytes.length, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable getWritable(byte[] bytes, int offset, int length, Writable w) throws IOException {
        if (bytes == null || length <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        DataInputBuffer in = new DataInputBuffer();
        try {
            in.reset(bytes, offset, length);
            w.readFields(in);
            Writable writable = w;
            return writable;
        }
        finally {
            in.close();
        }
    }

    public static Writable copyWritable(Writable src, Writable tgt) throws IOException {
        return Writables.copyWritable(Writables.getBytes(src), tgt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable copyWritable(byte[] bytes, Writable tgt) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            tgt.readFields(dis);
        }
        finally {
            dis.close();
        }
        return tgt;
    }
}

