/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSimpleByteRange {
    @Test
    public void testEmpty() {
        Assert.assertTrue((boolean)SimpleByteRange.isEmpty(null));
        SimpleByteRange r = new SimpleByteRange();
        Assert.assertTrue((boolean)SimpleByteRange.isEmpty(r));
        Assert.assertTrue((boolean)r.isEmpty());
        r.set(new byte[0]);
        Assert.assertEquals((long)0L, (long)r.getBytes().length);
        Assert.assertEquals((long)0L, (long)r.getOffset());
        Assert.assertEquals((long)0L, (long)r.getLength());
        Assert.assertTrue((boolean)Bytes.equals(new byte[0], r.deepCopyToNewArray()));
        Assert.assertEquals((long)0L, (long)r.compareTo(new SimpleByteRange(new byte[0], 0, 0)));
        Assert.assertEquals((long)0L, (long)((Object)r).hashCode());
    }

    @Test
    public void testBasics() {
        SimpleByteRange r = new SimpleByteRange(new byte[]{1, 3, 2});
        Assert.assertFalse((boolean)SimpleByteRange.isEmpty(r));
        Assert.assertNotNull((Object)r.getBytes());
        Assert.assertEquals((long)3L, (long)r.getBytes().length);
        Assert.assertEquals((long)0L, (long)r.getOffset());
        Assert.assertEquals((long)3L, (long)r.getLength());
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{1, 3, 2}, r.deepCopyToNewArray()));
        Assert.assertNotSame((Object)r.getBytes(), (Object)r.deepCopyToNewArray());
        Assert.assertTrue((((Object)r).hashCode() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)((Object)r).hashCode(), (long)r.deepCopy().hashCode());
        byte[] destination = new byte[]{-59};
        r.deepCopySubRangeTo(2, 1, destination, 0);
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{2}, destination));
        r.setLength(1);
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{1}, r.deepCopyToNewArray()));
        r.setLength(2);
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{1, 3}, r.deepCopyToNewArray()));
    }
}

