/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Iterator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Strings {
    public static final String DEFAULT_SEPARATOR = "=";
    public static final String DEFAULT_KEYVALUE_SEPARATOR = ", ";

    public static StringBuilder appendKeyValue(StringBuilder sb, String key, Object value2) {
        return Strings.appendKeyValue(sb, key, value2, DEFAULT_SEPARATOR, DEFAULT_KEYVALUE_SEPARATOR);
    }

    public static StringBuilder appendKeyValue(StringBuilder sb, String key, Object value2, String separator, String keyValueSeparator) {
        if (sb.length() > 0) {
            sb.append(keyValueSeparator);
        }
        return sb.append(key).append(separator).append(value2);
    }

    public static String domainNamePointerToHostName(String dnPtr) {
        if (dnPtr == null) {
            return null;
        }
        return dnPtr.endsWith(".") ? dnPtr.substring(0, dnPtr.length() - 1) : dnPtr;
    }

    public static boolean isEmpty(String input2) {
        return input2 == null || input2.length() == 0;
    }

    public static String padFront(String input2, char padding, int length) {
        if (input2.length() > length) {
            throw new IllegalArgumentException("input \"" + input2 + "\" longer than maxLength=" + length);
        }
        int numPaddingCharacters = length - input2.length();
        return Strings.repeat(padding, numPaddingCharacters) + input2;
    }

    public static String repeat(char c, int reapeatFor) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reapeatFor; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, Iterable<?> strings) {
        Iterator<?> i = strings.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(i.next().toString());
        while (i.hasNext()) {
            sb.append(separator);
            sb.append(i.next().toString());
        }
        return sb.toString();
    }
}

