/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimpleByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class SimplePositionedByteRange
extends SimpleByteRange
implements PositionedByteRange {
    private int position = 0;

    public SimplePositionedByteRange() {
    }

    public SimplePositionedByteRange(int capacity) {
        super(capacity);
    }

    public SimplePositionedByteRange(byte[] bytes) {
        super(bytes);
    }

    public SimplePositionedByteRange(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public PositionedByteRange unset() {
        this.position = 0;
        super.unset();
        return this;
    }

    @Override
    public PositionedByteRange set(int capacity) {
        this.position = 0;
        super.set(capacity);
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes) {
        this.position = 0;
        super.set(bytes);
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes, int offset, int length) {
        this.position = 0;
        super.set(bytes, offset, length);
        return this;
    }

    @Override
    public PositionedByteRange setOffset(int offset) {
        this.position = 0;
        super.setOffset(offset);
        return this;
    }

    @Override
    public PositionedByteRange setLength(int length) {
        this.position = Math.min(this.position, length);
        super.setLength(length);
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public PositionedByteRange setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getRemaining() {
        return this.length - this.position;
    }

    @Override
    public byte peek() {
        return this.bytes[this.offset + this.position];
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public PositionedByteRange get(byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(dst, 0, dst.length);
    }

    @Override
    public PositionedByteRange get(byte[] dst, int offset, int length) {
        if (0 == length) {
            return this;
        }
        super.get(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public PositionedByteRange put(byte val) {
        this.put(this.position++, val);
        return this;
    }

    @Override
    public PositionedByteRange put(byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(val, 0, val.length);
    }

    @Override
    public PositionedByteRange put(byte[] val, int offset, int length) {
        if (0 == length) {
            return this;
        }
        super.put(this.position, val, offset, length);
        this.position += length;
        return this;
    }

    @VisibleForTesting
    PositionedByteRange flip() {
        this.clearHashCache();
        this.length = this.position;
        this.position = this.offset;
        return this;
    }

    @VisibleForTesting
    PositionedByteRange clear() {
        this.clearHashCache();
        this.position = 0;
        this.length = this.bytes.length - this.offset;
        return this;
    }

    @Override
    public PositionedByteRange get(int index2, byte[] dst) {
        super.get(index2, dst);
        return this;
    }

    @Override
    public PositionedByteRange get(int index2, byte[] dst, int offset, int length) {
        super.get(index2, dst, offset, length);
        return this;
    }

    @Override
    public PositionedByteRange put(int index2, byte val) {
        super.put(index2, val);
        return this;
    }

    @Override
    public PositionedByteRange put(int index2, byte[] val) {
        super.put(index2, val);
        return this;
    }

    @Override
    public PositionedByteRange put(int index2, byte[] val, int offset, int length) {
        super.put(index2, val, offset, length);
        return this;
    }

    @Override
    public PositionedByteRange deepCopy() {
        SimplePositionedByteRange clone2 = new SimplePositionedByteRange(this.deepCopyToNewArray());
        clone2.position = this.position;
        return clone2;
    }

    @Override
    public PositionedByteRange shallowCopy() {
        SimplePositionedByteRange clone2 = new SimplePositionedByteRange(this.bytes, this.offset, this.length);
        clone2.position = this.position;
        return clone2;
    }

    @Override
    public PositionedByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimplePositionedByteRange clone2 = new SimplePositionedByteRange(this.bytes, this.offset + innerOffset, copyLength);
        clone2.position = this.position;
        return clone2;
    }
}

