/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class RegionSizeCalculator {
    private final Log LOG = LogFactory.getLog(RegionSizeCalculator.class);
    private final Map<byte[], Long> sizeMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    static final String ENABLE_REGIONSIZECALCULATOR = "hbase.regionsizecalculator.enable";

    public RegionSizeCalculator(HTable table) throws IOException {
        this(table, new HBaseAdmin(table.getConfiguration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegionSizeCalculator(HTable table, HBaseAdmin admin) throws IOException {
        try {
            if (!this.enabled(table.getConfiguration())) {
                this.LOG.info("Region size calculation disabled.");
                return;
            }
            this.LOG.info("Calculating region sizes for table \"" + new String(table.getTableName()) + "\".");
            Set tableRegionInfos = table.getRegionLocations().keySet();
            TreeSet<byte[]> tableRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (HRegionInfo regionInfo : tableRegionInfos) {
                tableRegions.add(regionInfo.getRegionName());
            }
            ClusterStatus clusterStatus = admin.getClusterStatus();
            Collection<ServerName> servers = clusterStatus.getServers();
            long megaByte = 0x100000L;
            for (ServerName serverName : servers) {
                ServerLoad serverLoad = clusterStatus.getLoad(serverName);
                for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                    byte[] regionId = regionLoad.getName();
                    if (!tableRegions.contains(regionId)) continue;
                    long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                    this.sizeMap.put(regionId, regionSizeBytes);
                    if (!this.LOG.isDebugEnabled()) continue;
                    this.LOG.debug("Region " + regionLoad.getNameAsString() + " has size " + regionSizeBytes);
                }
            }
            this.LOG.debug("Region sizes calculated");
        }
        finally {
            admin.close();
        }
    }

    boolean enabled(Configuration configuration) {
        return configuration.getBoolean(ENABLE_REGIONSIZECALCULATOR, true);
    }

    public long getRegionSize(byte[] regionId) {
        Long size2 = this.sizeMap.get(regionId);
        if (size2 == null) {
            this.LOG.debug("Unknown region:" + Arrays.toString(regionId));
            return 0L;
        }
        return size2;
    }

    public Map<byte[], Long> getRegionSizeMap() {
        return Collections.unmodifiableMap(this.sizeMap);
    }
}

