/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class KeyLocker<K extends Comparable<? super K>> {
    private static final Log LOG = LogFactory.getLog(KeyLocker.class);
    private static final int NB_CONCURRENT_LOCKS = 1000;
    private final Map<K, Pair<KeyLock<K>, AtomicInteger>> locks = new HashMap<K, Pair<KeyLock<K>, AtomicInteger>>(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReentrantLock acquireLock(K key) {
        Pair<KeyLock<K>, AtomicInteger> lock2;
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        KeyLocker keyLocker = this;
        synchronized (keyLocker) {
            lock2 = this.locks.get(key);
            if (lock2 == null) {
                lock2 = new Pair(new KeyLock(this, (Comparable)key, null), new AtomicInteger(1));
                this.locks.put(key, lock2);
            } else {
                lock2.getSecond().incrementAndGet();
            }
        }
        lock2.getFirst().lock();
        return lock2.getFirst();
    }

    public Map<K, Lock> acquireLocks(Set<K> keys) {
        HashMap<Comparable, ReentrantLock> locks = new HashMap<Comparable, ReentrantLock>(keys.size());
        TreeSet<K> sortedKeys = new TreeSet<K>(keys);
        for (Comparable key : sortedKeys) {
            locks.put(key, this.acquireLock(key));
        }
        return locks;
    }

    private synchronized void releaseLock(K key) {
        Pair<KeyLock<K>, AtomicInteger> lock2 = this.locks.get(key);
        if (lock2 != null) {
            if (lock2.getSecond().decrementAndGet() == 0) {
                this.locks.remove(key);
            }
        } else {
            String message = "Can't release the lock for " + key + ", this key is not in the key list." + " known keys are: " + this.locks.keySet();
            LOG.error(message);
            throw new RuntimeException(message);
        }
    }

    static class 1 {
    }

    static class KeyLock<K extends Comparable<? super K>>
    extends ReentrantLock {
        private static final long serialVersionUID = -12432857283423584L;
        private final transient KeyLocker<K> locker;
        private final K lockId;

        private KeyLock(KeyLocker<K> locker, K lockId) {
            this.locker = locker;
            this.lockId = lockId;
        }

        @Override
        public void unlock() {
            super.unlock();
            ((KeyLocker)this.locker).releaseLock(this.lockId);
        }

        /* synthetic */ KeyLock(KeyLocker x0, Comparable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

