/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.HttpServerUtil;
import org.apache.hadoop.http.HttpServer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;

@InterfaceAudience.Private
public class InfoServer
extends HttpServer {
    private final Configuration config;

    public InfoServer(String name, String bindAddress, int port, boolean findPort, Configuration c) throws IOException {
        super(name, bindAddress, port, findPort, c);
        this.config = c;
        this.fixupLogsServletLocation();
    }

    private void fixupLogsServletLocation() {
        String logDir;
        String logsContextPath = "/logs";
        Context oldLogsContext = null;
        for (Map.Entry e : this.defaultContexts.entrySet()) {
            if (!((Context)e.getKey()).getContextPath().equals("/logs")) continue;
            oldLogsContext = (Context)e.getKey();
            break;
        }
        if (oldLogsContext != null) {
            this.defaultContexts.put(oldLogsContext, Boolean.FALSE);
        }
        if ((logDir = System.getProperty("hbase.log.dir")) != null) {
            Context logContext = new Context((ContextHandlerCollection)this.webServer.getHandler(), "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(DefaultServlet.class, "/");
            HttpServerUtil.constrainHttpMethods(logContext);
            this.defaultContexts.put(logContext, true);
        }
    }

    @Override
    protected String getWebAppsPath(String appName) throws FileNotFoundException {
        String resourceName = "hbase-webapps/" + appName;
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException(resourceName + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    protected String getWebAppsPath() throws IOException {
        String master = "master";
        String p = this.getWebAppsPath("master");
        if (p.endsWith("master")) {
            return p.substring(0, p.lastIndexOf("master"));
        }
        return p;
    }
}

