/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class IdLock {
    private ConcurrentMap<Long, Entry> map = new ConcurrentHashMap<Long, Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getLockEntry(long id) throws IOException {
        Entry existing;
        Entry entry2 = new Entry(id);
        while ((existing = this.map.putIfAbsent(entry2.id, entry2)) != null) {
            Entry entry3 = existing;
            synchronized (entry3) {
                if (existing.isLocked) {
                    ++existing.numWaiters;
                    while (existing.isLocked) {
                        try {
                            existing.wait();
                        }
                        catch (InterruptedException e) {
                            --existing.numWaiters;
                            throw new InterruptedIOException("Interrupted waiting to acquire sparse lock");
                        }
                    }
                    --existing.numWaiters;
                    existing.isLocked = true;
                    return existing;
                }
            }
        }
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLockEntry(Entry entry2) {
        Entry entry3 = entry2;
        synchronized (entry3) {
            entry2.isLocked = false;
            if (entry2.numWaiters > 0) {
                entry2.notify();
            } else {
                this.map.remove(entry2.id);
            }
        }
    }

    void assertMapEmpty() {
        assert (this.map.size() == 0);
    }

    public static class Entry {
        private final long id;
        private int numWaiters;
        private boolean isLocked = true;

        private Entry(long id) {
            this.id = id;
        }

        public String toString() {
            return "id=" + this.id + ", numWaiter=" + this.numWaiters + ", isLocked=" + this.isLocked;
        }
    }
}

