/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Supplier;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ConcurrentIndex<K, V> {
    private final ConcurrentMap<K, Set<V>> container;
    private final Supplier<Set<V>> valueSetFactory;

    public ConcurrentIndex(Supplier<Set<V>> valueSetFactory) {
        this.valueSetFactory = valueSetFactory;
        this.container = new ConcurrentHashMap<K, Set<V>>();
    }

    public ConcurrentIndex(Comparator<V> valueComparator) {
        this(new DefaultValueSetFactory<V>(valueComparator));
    }

    public void put(K key, V value2) {
        Set<V> set = (Set<V>)this.container.get(key);
        if (set != null) {
            set.add(value2);
        } else {
            set = this.valueSetFactory.get();
            set.add(value2);
            Set<V> existing = this.container.putIfAbsent(key, set);
            if (existing != null) {
                existing.add(value2);
            }
        }
    }

    public Set<V> values(K key) {
        return (Set)this.container.get(key);
    }

    public boolean remove(K key, V value2) {
        Set set = (Set)this.container.get(key);
        boolean success2 = false;
        if (set != null) {
            success2 = set.remove(value2);
            if (set.isEmpty()) {
                this.container.remove(key);
            }
        }
        return success2;
    }

    private static class DefaultValueSetFactory<V>
    implements Supplier<Set<V>> {
        private final Comparator<V> comparator;

        public DefaultValueSetFactory(Comparator<V> comparator) {
            this.comparator = comparator;
        }

        @Override
        public Set<V> get() {
            return new ConcurrentSkipListSet<V>(this.comparator);
        }
    }
}

