/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class CollectionUtils {
    private static final List<Object> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));

    public static <T> Collection<T> nullSafe(Collection<T> in) {
        if (in == null) {
            return EMPTY_LIST;
        }
        return in;
    }

    public static <T> int nullSafeSize(Collection<T> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static <A, B> boolean nullSafeSameSize(Collection<A> a, Collection<B> b) {
        return CollectionUtils.nullSafeSize(a) == CollectionUtils.nullSafeSize(b);
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean notEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Iterator<T> i$ = collection.iterator();
        if (i$.hasNext()) {
            T t = i$.next();
            return t;
        }
        return null;
    }

    public static int getLastIndex(List<?> list2) {
        if (CollectionUtils.isEmpty(list2)) {
            return -1;
        }
        return list2.size() - 1;
    }

    public static boolean isLastIndex(List<?> list2, int index2) {
        return index2 == CollectionUtils.getLastIndex(list2);
    }

    public static <T> T getLast(List<T> list2) {
        if (CollectionUtils.isEmpty(list2)) {
            return null;
        }
        return list2.get(list2.size() - 1);
    }
}

