/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class ByteBufferArray {
    static final Log LOG = LogFactory.getLog(ByteBufferArray.class);
    static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private ByteBuffer[] buffers;
    private Lock[] locks;
    private int bufferSize = 0x400000;
    private int bufferCount;

    public ByteBufferArray(long capacity, boolean directByteBuffer) {
        if ((long)this.bufferSize > capacity / 16L) {
            this.bufferSize = (int)this.roundUp(capacity / 16L, 32768L);
        }
        this.bufferCount = (int)(this.roundUp(capacity, this.bufferSize) / (long)this.bufferSize);
        LOG.info("Allocating buffers total=" + StringUtils.byteDesc(capacity) + " , sizePerBuffer=" + StringUtils.byteDesc(this.bufferSize) + ", count=" + this.bufferCount);
        this.buffers = new ByteBuffer[this.bufferCount + 1];
        this.locks = new Lock[this.bufferCount + 1];
        for (int i = 0; i <= this.bufferCount; ++i) {
            this.locks[i] = new ReentrantLock();
            this.buffers[i] = i < this.bufferCount ? (directByteBuffer ? ByteBuffer.allocateDirect(this.bufferSize) : ByteBuffer.allocate(this.bufferSize)) : ByteBuffer.allocate(0);
        }
    }

    private long roundUp(long n, long to2) {
        return (n + to2 - 1L) / to2 * to2;
    }

    public int getMultiple(long start, int len, byte[] dstArray) {
        return this.getMultiple(start, len, dstArray, 0);
    }

    public int getMultiple(long start, int len, byte[] dstArray, int dstOffset) {
        this.multiple(start, len, dstArray, dstOffset, new Visitor(){

            @Override
            public void visit(ByteBuffer bb, byte[] array, int arrayIdx, int len) {
                bb.get(array, arrayIdx, len);
            }
        });
        return len;
    }

    public void putMultiple(long start, int len, byte[] srcArray) {
        this.putMultiple(start, len, srcArray, 0);
    }

    public void putMultiple(long start, int len, byte[] srcArray, int srcOffset) {
        this.multiple(start, len, srcArray, srcOffset, new Visitor(){

            @Override
            public void visit(ByteBuffer bb, byte[] array, int arrayIdx, int len) {
                bb.put(array, arrayIdx, len);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void multiple(long start, int len, byte[] array, int arrayOffset, Visitor visitor) {
        assert (len >= 0);
        long end = start + (long)len;
        int startBuffer = (int)(start / (long)this.bufferSize);
        int startOffset = (int)(start % (long)this.bufferSize);
        int endBuffer = (int)(end / (long)this.bufferSize);
        int endOffset = (int)(end % (long)this.bufferSize);
        assert (array.length >= len + arrayOffset);
        assert (startBuffer >= 0 && startBuffer < this.bufferCount);
        assert (endBuffer >= 0 && endBuffer < this.bufferCount || endBuffer == this.bufferCount && endOffset == 0);
        if (startBuffer >= this.locks.length || startBuffer < 0) {
            String msg = "Failed multiple, start=" + start + ",startBuffer=" + startBuffer + ",bufferSize=" + this.bufferSize;
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        int srcIndex = 0;
        int cnt = -1;
        for (int i = startBuffer; i <= endBuffer; ++i) {
            Lock lock2 = this.locks[i];
            lock2.lock();
            try {
                ByteBuffer bb = this.buffers[i];
                if (i == startBuffer) {
                    cnt = this.bufferSize - startOffset;
                    if (cnt > len) {
                        cnt = len;
                    }
                    bb.limit(startOffset + cnt).position(startOffset);
                } else if (i == endBuffer) {
                    cnt = endOffset;
                    bb.limit(cnt).position(0);
                } else {
                    cnt = this.bufferSize;
                    bb.limit(cnt).position(0);
                }
                visitor.visit(bb, array, srcIndex + arrayOffset, cnt);
                srcIndex += cnt;
                continue;
            }
            finally {
                lock2.unlock();
            }
        }
        assert (srcIndex == len);
    }

    private static interface Visitor {
        public void visit(ByteBuffer var1, byte[] var2, int var3, int var4);
    }
}

