/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedBlob;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestOrderedBlob {
    static final byte[][] VALUES = new byte[][]{null, Bytes.toBytes(""), Bytes.toBytes("1"), Bytes.toBytes("22"), Bytes.toBytes("333"), Bytes.toBytes("4444"), Bytes.toBytes("55555"), Bytes.toBytes("666666"), Bytes.toBytes("7777777"), Bytes.toBytes("88888888"), Bytes.toBytes("999999999")};

    @Test
    public void testEncodedLength() {
        SimplePositionedByteRange buff = new SimplePositionedByteRange(20);
        for (OrderedBlob type : new OrderedBlob[]{OrderedBlob.ASCENDING, OrderedBlob.DESCENDING}) {
            for (byte[] val : VALUES) {
                buff.setPosition(0);
                type.encode((PositionedByteRange)buff, val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + Bytes.toStringBinary(val)), (long)buff.getPosition(), (long)type.encodedLength(val));
            }
        }
    }
}

