/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class BlockCacheViewTmplImpl
extends AbstractTemplateImpl
implements BlockCacheViewTmpl.Intf {
    private final CacheConfig cacheConfig;
    private final Configuration conf;
    private final String bcn;
    private final String bcv;

    protected static BlockCacheViewTmpl.ImplData __jamon_setOptionalArguments(BlockCacheViewTmpl.ImplData p_implData) {
        return p_implData;
    }

    public BlockCacheViewTmplImpl(TemplateManager p_templateManager, BlockCacheViewTmpl.ImplData p_implData) {
        super(p_templateManager, BlockCacheViewTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.cacheConfig = p_implData.getCacheConfig();
        this.conf = p_implData.getConf();
        this.bcn = p_implData.getBcn();
        this.bcv = p_implData.getBcv();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        BlockCache bc = this.cacheConfig.getBlockCache();
        BlockCache[] bcs = bc.getBlockCaches();
        if (this.bcn.equals("L1")) {
            bc = bcs == null || bcs.length == 0 ? bc : bcs[0];
        } else {
            if (bcs.length < 2) {
                System.out.println("There is no L2 block cache");
                return;
            }
            bc = bcs[1];
        }
        BlockCacheUtil.CachedBlocksByFile cbsbf = BlockCacheUtil.getLoadedCachedBlocksByFile(this.conf, bc);
        if (this.bcv.equals("file")) {
            this.__jamon_innerUnit__bc_by_file(jamonWriter, cbsbf);
        } else {
            jamonWriter.write("{");
            Escaping.HTML.write(StandardEmitter.valueOf(BlockCacheUtil.toJSON(bc)), jamonWriter);
            jamonWriter.write(", ");
            Escaping.HTML.write(StandardEmitter.valueOf(cbsbf), jamonWriter);
            jamonWriter.write(" }");
        }
        jamonWriter.write("\n");
        cbsbf = null;
    }

    private void __jamon_innerUnit__bc_by_file(Writer jamonWriter, BlockCacheUtil.CachedBlocksByFile cbsbf) throws IOException {
        jamonWriter.write("[");
        for (Map.Entry e : cbsbf.getCachedBlockStatsByFile().entrySet()) {
            Escaping.HTML.write(StandardEmitter.valueOf(BlockCacheUtil.toJSON((String)e.getKey(), (NavigableSet)e.getValue())), jamonWriter);
        }
        jamonWriter.write("]\n");
    }
}

