/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class AssignmentManagerStatusTmplImpl
extends AbstractTemplateImpl
implements AssignmentManagerStatusTmpl.Intf {
    private final AssignmentManager assignmentManager;
    private final int limit;

    protected static AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(AssignmentManagerStatusTmpl.ImplData p_implData) {
        if (!p_implData.getLimit__IsNotDefault()) {
            p_implData.setLimit(100);
        }
        return p_implData;
    }

    public AssignmentManagerStatusTmplImpl(TemplateManager p_templateManager, AssignmentManagerStatusTmpl.ImplData p_implData) {
        super(p_templateManager, AssignmentManagerStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.assignmentManager = p_implData.getAssignmentManager();
        this.limit = p_implData.getLimit();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        Map<String, RegionState> rit = this.assignmentManager.getRegionStates().getRegionsInTransition();
        Configuration conf = HBaseConfiguration.create();
        int ritThreshold = conf.getInt("hbase.metrics.rit.stuck.warning.threshold", 60000);
        int numOfRITOverThreshold = 0;
        long maxRITTime = Long.MIN_VALUE;
        long currentTime = System.currentTimeMillis();
        String regionIDForOldestRIT = "";
        for (Map.Entry<String, RegionState> e : rit.entrySet()) {
            long ritTime = currentTime - e.getValue().getStamp();
            if (ritTime > (long)ritThreshold) {
                ++numOfRITOverThreshold;
            }
            if (maxRITTime >= ritTime) continue;
            maxRITTime = ritTime;
            regionIDForOldestRIT = e.getKey();
        }
        int toRemove = rit.size() - this.limit;
        int removed = 0;
        if (toRemove > 0) {
            Iterator<Map.Entry<String, RegionState>> it = rit.entrySet().iterator();
            while (it.hasNext() && toRemove > 0) {
                Map.Entry<String, RegionState> e = it.next();
                if (HRegionInfo.FIRST_META_REGIONINFO.getEncodedName().equals(e.getKey()) || regionIDForOldestRIT.equals(e.getKey())) continue;
                it.remove();
                --toRemove;
                ++removed;
            }
        }
        if (!rit.isEmpty()) {
            jamonWriter.write("\n    <section>\n    <h2>Regions in Transition</h2>\n    <table class=\"table table-striped\">\n            <tr><th>Region</th><th>State</th><th>RIT time (ms)</th></tr>\n            ");
            for (Map.Entry<String, RegionState> entry2 : rit.entrySet()) {
                jamonWriter.write("\n            ");
                if (regionIDForOldestRIT.equals(entry2.getKey())) {
                    jamonWriter.write("\n                    <tr BGCOLOR=\"#FE2E2E\" >\n            ");
                } else {
                    jamonWriter.write("\n                    <tr>\n            ");
                }
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(entry2.getKey()), jamonWriter);
                jamonWriter.write("</td><td>");
                Escaping.HTML.write(StandardEmitter.valueOf(entry2.getValue().toDescriptiveString()), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(currentTime - entry2.getValue().getStamp()), jamonWriter);
                jamonWriter.write(" </td></tr>\n            ");
            }
            jamonWriter.write("\n            <tr BGCOLOR=\"#D7DF01\"> <td>Total number of Regions in Transition for more than ");
            Escaping.HTML.write(StandardEmitter.valueOf(ritThreshold), jamonWriter);
            jamonWriter.write(" milliseconds</td><td> ");
            Escaping.HTML.write(StandardEmitter.valueOf(numOfRITOverThreshold), jamonWriter);
            jamonWriter.write("</td><td></td>\n            </tr>\n    <tr> <td> Total number of Regions in Transition</td><td>");
            Escaping.HTML.write(StandardEmitter.valueOf(rit.size()), jamonWriter);
            jamonWriter.write(" </td><td></td>\n    </table>\n    ");
            if (removed > 0) {
                jamonWriter.write("\n    (");
                Escaping.HTML.write(StandardEmitter.valueOf(removed), jamonWriter);
                jamonWriter.write(" more regions in transition not shown)\n    ");
            }
            jamonWriter.write("\n    </section>\n");
        }
        jamonWriter.write("\n\n");
    }
}

