/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.common;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TaskMonitorTmplImpl
extends AbstractTemplateImpl
implements TaskMonitorTmpl.Intf {
    private final String filter;
    private final TaskMonitor taskMonitor;
    private final String format;

    protected static TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(TaskMonitorTmpl.ImplData p_implData) {
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getTaskMonitor__IsNotDefault()) {
            p_implData.setTaskMonitor(TaskMonitor.get());
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        return p_implData;
    }

    public TaskMonitorTmplImpl(TemplateManager p_templateManager, TaskMonitorTmpl.ImplData p_implData) {
        super(p_templateManager, TaskMonitorTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.filter = p_implData.getFilter();
        this.taskMonitor = p_implData.getTaskMonitor();
        this.format = p_implData.getFormat();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        List<MonitoredTask> tasks = this.taskMonitor.getTasks();
        Iterator<MonitoredTask> iter2 = tasks.iterator();
        while (iter2.hasNext()) {
            MonitoredTask t = iter2.next();
            if (this.filter.equals("general")) {
                if (!(t instanceof MonitoredRPCHandler)) continue;
                iter2.remove();
                continue;
            }
            if (this.filter.equals("handler")) {
                if (t instanceof MonitoredRPCHandler) continue;
                iter2.remove();
                continue;
            }
            if (this.filter.equals("rpc")) {
                if (t instanceof MonitoredRPCHandler && ((MonitoredRPCHandler)t).isRPCRunning()) continue;
                iter2.remove();
                continue;
            }
            if (!this.filter.equals("operation") || t instanceof MonitoredRPCHandler && ((MonitoredRPCHandler)t).isOperationRunning()) continue;
            iter2.remove();
        }
        long now = System.currentTimeMillis();
        Collections.reverse(tasks);
        boolean first = true;
        if (this.format.equals("json")) {
            jamonWriter.write("\n[");
            for (MonitoredTask task : tasks) {
                if (first) {
                    first = false;
                } else {
                    jamonWriter.write(",");
                }
                Escaping.HTML.write(StandardEmitter.valueOf(task.toJSON()), jamonWriter);
            }
            jamonWriter.write("]\n");
        } else {
            jamonWriter.write("\n<h2>Tasks</h2>\n  <ul class=\"nav nav-pills\">\n    <li ");
            if (this.filter.equals("all")) {
                jamonWriter.write("class=\"active\"");
            }
            jamonWriter.write("><a href=\"?filter=all\">Show All Monitored Tasks</a></li>\n    <li ");
            if (this.filter.equals("general")) {
                jamonWriter.write("class=\"active\"");
            }
            jamonWriter.write("><a href=\"?filter=general\">Show non-RPC Tasks</a></li>\n    <li ");
            if (this.filter.equals("handler")) {
                jamonWriter.write("class=\"active\"");
            }
            jamonWriter.write("><a href=\"?filter=handler\">Show All RPC Handler Tasks</a></li>\n    <li ");
            if (this.filter.equals("rpc")) {
                jamonWriter.write("class=\"active\"");
            }
            jamonWriter.write("><a href=\"?filter=rpc\">Show Active RPC Calls</a></li>\n    <li ");
            if (this.filter.equals("operation")) {
                jamonWriter.write("class=\"active\"");
            }
            jamonWriter.write("><a href=\"?filter=operation\">Show Client Operations</a></li>\n    <li><a href=\"?format=json&filter=");
            Escaping.HTML.write(StandardEmitter.valueOf(this.filter), jamonWriter);
            jamonWriter.write("\">View as JSON</a></li>\n  </ul>\n  ");
            if (tasks.isEmpty()) {
                jamonWriter.write("\n    <p>No tasks currently running on this node.</p>\n  ");
            } else {
                jamonWriter.write("\n    <table class=\"table\">\n    <tr>\n      <th>Start Time</th>\n      <th>Description</th>\n      <th>State</th>\n      <th>Status</th>\n    </tr>\n    ");
                for (MonitoredTask task : tasks) {
                    jamonWriter.write("\n    <tr class=\"");
                    this.__jamon_innerUnit__stateCss(jamonWriter, task.getState());
                    jamonWriter.write("\">\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf(new Date(task.getStartTime())), jamonWriter);
                    jamonWriter.write("</td>\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf(task.getDescription()), jamonWriter);
                    jamonWriter.write("</td>\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((Object)task.getState()), jamonWriter);
                    jamonWriter.write("\n          (since ");
                    Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStateTime())), jamonWriter);
                    jamonWriter.write(" ago)\n      </td>\n      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf(task.getStatus()), jamonWriter);
                    jamonWriter.write("\n          (since ");
                    Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStatusTime())), jamonWriter);
                    jamonWriter.write(" \n          ago)</td>\n    </tr>\n    ");
                }
                jamonWriter.write("\n    </table>\n\n  ");
            }
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n\n\n");
    }

    private void __jamon_innerUnit__stateCss(Writer jamonWriter, MonitoredTask.State state) throws IOException {
        if (state == MonitoredTask.State.COMPLETE) {
            jamonWriter.write("alert alert-success");
        } else if (state == MonitoredTask.State.ABORTED) {
            jamonWriter.write("alert alert-error");
        }
    }
}

