/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsThriftServerSourceImpl
extends BaseSourceImpl
implements MetricsThriftServerSource {
    private MutableHistogram batchGetStat;
    private MutableHistogram batchMutateStat;
    private MutableHistogram queueTimeStat;
    private MutableHistogram thriftCallStat;
    private MutableHistogram thriftSlowCallStat;
    private MutableGaugeLong callQueueLenGauge;

    public MetricsThriftServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.batchGetStat = this.getMetricsRegistry().newHistogram("batchGet");
        this.batchMutateStat = this.getMetricsRegistry().newHistogram("batchMutate");
        this.queueTimeStat = this.getMetricsRegistry().newHistogram("timeInQueue");
        this.thriftCallStat = this.getMetricsRegistry().newHistogram("thriftCall");
        this.thriftSlowCallStat = this.getMetricsRegistry().newHistogram("slowThriftCall");
        this.callQueueLenGauge = this.getMetricsRegistry().getLongGauge("callQueueLen", 0L);
    }

    @Override
    public void incTimeInQueue(long time) {
        this.queueTimeStat.add(time);
    }

    @Override
    public void setCallQueueLen(int len) {
        this.callQueueLenGauge.set(len);
    }

    @Override
    public void incNumRowKeysInBatchGet(int diff2) {
        this.batchGetStat.add(diff2);
    }

    @Override
    public void incNumRowKeysInBatchMutate(int diff2) {
        this.batchMutateStat.add(diff2);
    }

    @Override
    public void incMethodTime(String name, long time) {
        MutableHistogram s2 = this.getMetricsRegistry().getHistogram(name);
        s2.add(time);
    }

    @Override
    public void incCall(long time) {
        this.thriftCallStat.add(time);
    }

    @Override
    public void incSlowCall(long time) {
        this.thriftSlowCallStat.add(time);
    }
}

