/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.BaseMasterAndRegionObserver;
import org.apache.hadoop.hbase.coprocessor.BaseRegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityControllerNotReadyException;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hadoop.hbase.security.visibility.VisibilityReplicationEndpoint;
import org.apache.hadoop.hbase.security.visibility.VisibilityScanDeleteTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class VisibilityController
extends BaseMasterAndRegionObserver
implements VisibilityLabelsProtos.VisibilityLabelsService.Interface,
CoprocessorService {
    private static final Log LOG = LogFactory.getLog(VisibilityController.class);
    private static final Log AUDITLOG = LogFactory.getLog("SecurityLogger." + VisibilityController.class.getName());
    private boolean labelsRegion = false;
    private boolean accessControllerAvailable = false;
    private Configuration conf;
    private volatile boolean initialized = false;
    private boolean checkAuths = false;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private List<String> superUsers;
    private List<String> superGroups;
    private VisibilityLabelService visibilityLabelService;
    boolean authorizationEnabled;
    private static ArrayList<Byte> RESERVED_VIS_TAG_TYPES = new ArrayList();

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        this.conf = env.getConfiguration();
        this.authorizationEnabled = this.conf.getBoolean("hbase.security.authorization", true);
        if (!this.authorizationEnabled) {
            LOG.warn("The VisibilityController has been loaded with authorization checks disabled.");
        }
        if (HFile.getFormatVersion(this.conf) < 3) {
            throw new RuntimeException("A minimum HFile version of 3 is required to persist visibility labels. Consider setting hfile.format.version accordingly.");
        }
        if (env instanceof RegionServerCoprocessorEnvironment) {
            throw new RuntimeException("Visibility controller should not be configured as 'hbase.coprocessor.regionserver.classes'.");
        }
        if (!(env instanceof MasterCoprocessorEnvironment)) {
            this.visibilityLabelService = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService(this.conf);
        }
        Pair<List<String>, List<String>> superUsersAndGroups = VisibilityUtils.getSystemAndSuperUsers(this.conf);
        this.superUsers = superUsersAndGroups.getFirst();
        this.superGroups = superUsersAndGroups.getSecond();
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        MasterServices master = ctx.getEnvironment().getMasterServices();
        if (!MetaReader.tableExists(master.getCatalogTracker(), VisibilityConstants.LABELS_TABLE_NAME)) {
            HTableDescriptor labelsTable = new HTableDescriptor(VisibilityConstants.LABELS_TABLE_NAME);
            HColumnDescriptor labelsColumn = new HColumnDescriptor(VisibilityConstants.LABELS_TABLE_FAMILY);
            labelsColumn.setBloomFilterType(BloomType.NONE);
            labelsColumn.setBlockCacheEnabled(false);
            labelsTable.addFamily(labelsColumn);
            labelsTable.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            labelsTable.setValue(Bytes.toBytes("hbase.regionserver.disallow.writes.when.recovering"), Bytes.toBytes(true));
            master.createTable(labelsTable, null);
        }
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (VisibilityConstants.LABELS_TABLE_NAME.equals(tableName)) {
            throw new ConstraintException("Cannot disable " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (e.getEnvironment().getRegion().getRegionInfo().getTable().equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = true;
            this.accessControllerAvailable = CoprocessorHost.getLoadedCoprocessors().contains(AccessController.class.getName());
            if (!e.getEnvironment().getRegion().isRecovering()) {
                this.initVisibilityLabelService(e.getEnvironment());
            }
        } else {
            this.checkAuths = e.getEnvironment().getConfiguration().getBoolean("hbase.security.visibility.mutations.checkauths", false);
            this.initVisibilityLabelService(e.getEnvironment());
        }
    }

    @Override
    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (this.labelsRegion) {
            this.initVisibilityLabelService(e.getEnvironment());
            LOG.debug("post labels region log replay");
        }
    }

    private void initVisibilityLabelService(RegionCoprocessorEnvironment env) {
        try {
            this.visibilityLabelService.init(env);
            this.initialized = true;
        }
        catch (IOException ioe) {
            LOG.error("Error while initializing VisibilityLabelService..", ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (c.getEnvironment().getRegion().getRegionInfo().getTable().isSystemTable()) {
            return;
        }
        HashMap<String, List<Tag>> labelCache = new HashMap<String, List<Tag>>();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = miniBatchOp.getOperation(i);
            CellVisibility cellVisibility = null;
            try {
                cellVisibility = m.getCellVisibility();
            }
            catch (DeserializationException de) {
                miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, de.getMessage()));
                continue;
            }
            boolean sanityFailure = false;
            boolean modifiedTagFound = false;
            Pair<Boolean, Object> pair2 = new Pair<Boolean, Object>(false, null);
            CellScanner cellScanner = m.cellScanner();
            while (cellScanner.advance()) {
                pair2 = this.checkForReservedVisibilityTagPresence(cellScanner.current(), pair2);
                if (!pair2.getFirst().booleanValue()) {
                    if (!this.authorizationEnabled) break;
                    miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, "Mutation contains cell with reserved type tag"));
                    sanityFailure = true;
                    break;
                }
                Tag tag = (Tag)pair2.getSecond();
                if (cellVisibility != null || tag == null) continue;
                cellVisibility = new CellVisibility(Bytes.toString(tag.getBuffer(), tag.getTagOffset(), tag.getTagLength()));
                modifiedTagFound = true;
            }
            if (sanityFailure || cellVisibility == null) continue;
            String labelsExp = cellVisibility.getExpression();
            List<Tag> visibilityTags = (List<Tag>)labelCache.get(labelsExp);
            if (visibilityTags == null) {
                boolean authCheck = this.authorizationEnabled && this.checkAuths && !this.isSystemOrSuperUser();
                try {
                    visibilityTags = this.visibilityLabelService.createVisibilityExpTags(labelsExp, true, authCheck);
                }
                catch (InvalidLabelException e) {
                    miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, e.getMessage()));
                }
                if (visibilityTags != null) {
                    labelCache.put(labelsExp, visibilityTags);
                }
            }
            if (visibilityTags == null) continue;
            ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
            CellScanner cellScanner2 = m.cellScanner();
            while (cellScanner2.advance()) {
                Cell cell = cellScanner2.current();
                List<Tag> tags = Tag.asList(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLengthUnsigned());
                if (modifiedTagFound) {
                    this.removeReplicationVisibilityTag(tags);
                }
                tags.addAll(visibilityTags);
                KeyValue updatedCell = new KeyValue(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType(cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), tags);
                updatedCells.add(updatedCell);
            }
            m.getFamilyCellMap().clear();
            for (Cell cell : updatedCells) {
                if (m instanceof Put) {
                    Put p = (Put)m;
                    p.add(cell);
                    continue;
                }
                if (!(m instanceof Delete)) continue;
                Delete d = (Delete)m;
                d.addDeleteMarker(cell);
            }
        }
    }

    @Override
    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation delete2, Cell cell, byte[] byteNow, Get get2) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = delete2.getCellVisibility();
        }
        catch (DeserializationException de) {
            throw new IOException("Invalid cell visibility specified " + delete2, de);
        }
        List<Tag> visibilityTags = new ArrayList<Tag>();
        if (cellVisibility != null) {
            String labelsExp = cellVisibility.getExpression();
            try {
                visibilityTags = this.visibilityLabelService.createVisibilityExpTags(labelsExp, false, false);
            }
            catch (InvalidLabelException e) {
                throw new IOException("Invalid cell visibility specified " + labelsExp, e);
            }
        }
        get2.setFilter(new DeleteVersionVisibilityExpressionFilter(visibilityTags, (byte)1));
        List<Cell> result2 = ctx.getEnvironment().getRegion().get(get2, false);
        if (result2.size() < get2.getMaxVersions()) {
            kv.updateLatestStamp(Bytes.toBytes(Long.MIN_VALUE));
            return;
        }
        if (result2.size() > get2.getMaxVersions()) {
            throw new RuntimeException("Unexpected size: " + result2.size() + ". Results more than the max versions obtained.");
        }
        KeyValue getkv = KeyValueUtil.ensureKeyValue(result2.get(get2.getMaxVersions() - 1));
        Bytes.putBytes(kv.getBuffer(), kv.getTimestampOffset(), getkv.getBuffer(), getkv.getTimestampOffset(), 8);
        ctx.bypass();
    }

    private Pair<Boolean, Tag> checkForReservedVisibilityTagPresence(Cell cell, Pair<Boolean, Tag> pair2) throws IOException {
        if (pair2 == null) {
            pair2 = new Pair<Boolean, Object>(false, null);
        } else {
            pair2.setFirst(false);
            pair2.setSecond(null);
        }
        if (this.isSystemOrSuperUser()) {
            Tag modifiedTag = null;
            if (cell.getTagsLength() > 0) {
                Iterator<Tag> tagsIterator = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
                while (tagsIterator.hasNext()) {
                    Tag tag = tagsIterator.next();
                    if (tag.getType() != 7) continue;
                    modifiedTag = tag;
                    break;
                }
            }
            pair2.setFirst(true);
            pair2.setSecond(modifiedTag);
            return pair2;
        }
        if (cell.getTagsLength() > 0) {
            Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            while (tagsItr.hasNext()) {
                if (!RESERVED_VIS_TAG_TYPES.contains(tagsItr.next().getType())) continue;
                return pair2;
            }
        }
        pair2.setFirst(true);
        return pair2;
    }

    private boolean checkForReservedVisibilityTagPresence(Cell cell) throws IOException {
        if (this.isSystemOrSuperUser()) {
            return true;
        }
        if (cell.getTagsLengthUnsigned() > 0) {
            Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLengthUnsigned());
            while (tagsItr.hasNext()) {
                if (!RESERVED_VIS_TAG_TYPES.contains(tagsItr.next().getType())) continue;
                return false;
            }
        }
        return true;
    }

    private void removeReplicationVisibilityTag(List<Tag> tags) throws IOException {
        Iterator<Tag> iterator2 = tags.iterator();
        while (iterator2.hasNext()) {
            Tag tag = iterator2.next();
            if (tag.getType() != 7) continue;
            iterator2.remove();
            break;
        }
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan2, RegionScanner s2) throws IOException {
        TableName table;
        if (!this.initialized) {
            throw new VisibilityControllerNotReadyException("VisibilityController not yet initialized!");
        }
        if (!this.authorizationEnabled) {
            return s2;
        }
        HRegion region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        try {
            authorizations = scan2.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        if (authorizations == null && (table = region.getRegionInfo().getTable()).isSystemTable() && !table.equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            return s2;
        }
        Filter visibilityLabelFilter = VisibilityUtils.createVisibilityLabelFilter(region, authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter2 = scan2.getFilter();
            if (filter2 != null) {
                scan2.setFilter(new FilterList(filter2, visibilityLabelFilter));
            } else {
                scan2.setFilter(visibilityLabelFilter);
            }
        }
        return s2;
    }

    @Override
    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        if (!this.authorizationEnabled) {
            return delTracker;
        }
        HRegion region = ctx.getEnvironment().getRegion();
        TableName table = region.getRegionInfo().getTable();
        if (table.isSystemTable()) {
            return delTracker;
        }
        return new VisibilityScanDeleteTracker();
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan2, RegionScanner s2) throws IOException {
        User user = VisibilityUtils.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s2, user.getShortName());
        }
        return s2;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s2, List<Result> result2, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s2);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s2) throws IOException {
        this.requireScannerOwner(s2);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s2) throws IOException {
        this.scannerOwners.remove(s2);
    }

    private void requireScannerOwner(InternalScanner s2) throws AccessDeniedException {
        String requestUName = RpcServer.getRequestUserName();
        String owner = this.scannerOwners.get(s2);
        if (this.authorizationEnabled && owner != null && !owner.equals(requestUName)) {
            throw new AccessDeniedException("User '" + requestUName + "' is not the scanner owner!");
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get2, List<Cell> results) throws IOException {
        TableName table;
        if (!this.initialized) {
            throw new VisibilityControllerNotReadyException("VisibilityController not yet initialized");
        }
        if (!this.authorizationEnabled) {
            return;
        }
        HRegion region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        try {
            authorizations = get2.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        if (authorizations == null && (table = region.getRegionInfo().getTable()).isSystemTable() && !table.equals(VisibilityConstants.LABELS_TABLE_NAME)) {
            return;
        }
        Filter visibilityLabelFilter = VisibilityUtils.createVisibilityLabelFilter(e.getEnvironment().getRegion(), authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter2 = get2.getFilter();
            if (filter2 != null) {
                get2.setFilter(new FilterList(filter2, visibilityLabelFilter));
            } else {
                get2.setFilter(visibilityLabelFilter);
            }
        }
    }

    private boolean isSystemOrSuperUser() throws IOException {
        User activeUser = VisibilityUtils.getActiveUser();
        if (this.superUsers.contains(activeUser.getShortName())) {
            return true;
        }
        String[] groups = activeUser.getGroupNames();
        if (groups != null && groups.length > 0) {
            for (String group : groups) {
                if (!this.superGroups.contains(group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append2) throws IOException {
        if (!this.authorizationEnabled) {
            return null;
        }
        CellScanner cellScanner = append2.cellScanner();
        while (cellScanner.advance()) {
            if (this.checkForReservedVisibilityTagPresence(cellScanner.current())) continue;
            throw new FailedSanityCheckException("Append contains cell with reserved type tag");
        }
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
        if (!this.authorizationEnabled) {
            return null;
        }
        CellScanner cellScanner = increment.cellScanner();
        while (cellScanner.advance()) {
            if (this.checkForReservedVisibilityTagPresence(cellScanner.current())) continue;
            throw new FailedSanityCheckException("Increment contains cell with reserved type tag");
        }
        return null;
    }

    @Override
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        ArrayList<Tag> tags = Lists.newArrayList();
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = mutation.getCellVisibility();
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
        if (cellVisibility == null) {
            return newCell;
        }
        boolean authCheck = this.authorizationEnabled && this.checkAuths && !this.isSystemOrSuperUser();
        tags.addAll(this.visibilityLabelService.createVisibilityExpTags(cellVisibility.getExpression(), true, authCheck));
        if (newCell.getTagsLengthUnsigned() > 0) {
            Iterator<Tag> tagsItr = CellUtil.tagsIterator(newCell.getTagsArray(), newCell.getTagsOffset(), newCell.getTagsLengthUnsigned());
            while (tagsItr.hasNext()) {
                Tag tag = tagsItr.next();
                if (tag.getType() == 2 || tag.getType() == 4) continue;
                tags.add(tag);
            }
        }
        KeyValue rewriteKv = new KeyValue(newCell.getRowArray(), newCell.getRowOffset(), newCell.getRowLength(), newCell.getFamilyArray(), newCell.getFamilyOffset(), newCell.getFamilyLength(), newCell.getQualifierArray(), newCell.getQualifierOffset(), newCell.getQualifierLength(), newCell.getTimestamp(), KeyValue.Type.codeToType(newCell.getTypeByte()), newCell.getValueArray(), newCell.getValueOffset(), newCell.getValueLength(), tags);
        rewriteKv.setMvccVersion(newCell.getMvccVersion());
        return rewriteKv;
    }

    @Override
    public Service getService() {
        return VisibilityLabelsProtos.VisibilityLabelsService.newReflectiveService(this);
    }

    @Override
    public synchronized void addLabels(RpcController controller, VisibilityLabelsProtos.VisibilityLabelsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List<VisibilityLabelsProtos.VisibilityLabel> visLabels = request.getVisLabelList();
        if (!this.initialized) {
            this.setExceptionResults(visLabels.size(), new VisibilityControllerNotReadyException("VisibilityController not yet initialized!"), response);
        } else {
            ArrayList<byte[]> labels = new ArrayList<byte[]>(visLabels.size());
            try {
                if (this.authorizationEnabled) {
                    this.checkCallingUserAuth();
                }
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (VisibilityLabelsProtos.VisibilityLabel visLabel : visLabels) {
                    byte[] label = visLabel.getLabel().toByteArray();
                    labels.add(label);
                    response.addResult(successResult);
                }
                if (!labels.isEmpty()) {
                    OperationStatus[] opStatus = this.visibilityLabelService.addLabels(labels);
                    this.logResult(true, "addLabels", "Adding labels allowed", null, labels, null);
                    int i = 0;
                    for (OperationStatus status : opStatus) {
                        while (response.getResult(i) != successResult) {
                            ++i;
                        }
                        if (status.getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) {
                            ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                            failureResultBuilder.setException(ResponseConverter.buildException(new DoNotRetryIOException(status.getExceptionMsg())));
                            response.setResult(i, failureResultBuilder.build());
                        }
                        ++i;
                    }
                }
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "addLabels", e.getMessage(), null, labels, null);
                LOG.error("User is not having required permissions to add labels", e);
                this.setExceptionResults(visLabels.size(), e, response);
            }
            catch (IOException e) {
                LOG.error(e);
                this.setExceptionResults(visLabels.size(), e, response);
            }
        }
        done.run(response.build());
    }

    private void setExceptionResults(int size2, IOException e, VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response) {
        ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        failureResultBuilder.setException(ResponseConverter.buildException(e));
        ClientProtos.RegionActionResult failureResult = failureResultBuilder.build();
        for (int i = 0; i < size2; ++i) {
            response.addResult(i, failureResult);
        }
    }

    @Override
    public synchronized void setAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List<ByteString> auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), new VisibilityControllerNotReadyException("VisibilityController not yet initialized!"), response);
        } else {
            byte[] user = request.getUser().toByteArray();
            ArrayList<byte[]> labelAuths = new ArrayList<byte[]>(auths.size());
            try {
                if (this.authorizationEnabled) {
                    this.checkCallingUserAuth();
                }
                for (ByteString authBS : auths) {
                    labelAuths.add(authBS.toByteArray());
                }
                OperationStatus[] opStatus = this.visibilityLabelService.setAuths(user, labelAuths);
                this.logResult(true, "setAuths", "Setting authorization for labels allowed", user, labelAuths, null);
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (OperationStatus status : opStatus) {
                    if (status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        response.addResult(successResult);
                        continue;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException(new DoNotRetryIOException(status.getExceptionMsg())));
                    response.addResult(failureResultBuilder.build());
                }
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "setAuths", e.getMessage(), user, labelAuths, null);
                LOG.error("User is not having required permissions to set authorization", e);
                this.setExceptionResults(auths.size(), e, response);
            }
            catch (IOException e) {
                LOG.error(e);
                this.setExceptionResults(auths.size(), e, response);
            }
        }
        done.run(response.build());
    }

    private void logResult(boolean isAllowed, String request, String reason, byte[] user, List<byte[]> labelAuths, String regex) {
        if (AUDITLOG.isTraceEnabled()) {
            InetAddress remoteAddr = RpcServer.getRemoteAddress();
            ArrayList<String> labelAuthsStr = new ArrayList<String>();
            if (labelAuths != null) {
                int labelAuthsSize = labelAuths.size();
                labelAuthsStr = new ArrayList(labelAuthsSize);
                for (int i = 0; i < labelAuthsSize; ++i) {
                    labelAuthsStr.add(Bytes.toString(labelAuths.get(i)));
                }
            }
            User requestingUser = null;
            try {
                requestingUser = VisibilityUtils.getActiveUser();
            }
            catch (IOException e) {
                LOG.warn("Failed to get active system user.");
                LOG.debug("Details on failure to get active system user.", e);
            }
            AUDITLOG.trace("Access " + (isAllowed ? "allowed" : "denied") + " for user " + (requestingUser != null ? requestingUser.getShortName() : "UNKNOWN") + "; reason: " + reason + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + request + "; user: " + (user != null ? Short.valueOf(Bytes.toShort(user)) : "null") + "; labels: " + labelAuthsStr + "; regex: " + regex);
        }
    }

    @Override
    public synchronized void getAuths(RpcController controller, VisibilityLabelsProtos.GetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.GetAuthsResponse> done) {
        VisibilityLabelsProtos.GetAuthsResponse.Builder response = VisibilityLabelsProtos.GetAuthsResponse.newBuilder();
        if (!this.initialized) {
            controller.setFailed("VisibilityController not yet initialized");
        } else {
            byte[] user = request.getUser().toByteArray();
            List<String> labels = null;
            try {
                if (this.authorizationEnabled && this.accessControllerAvailable && !this.isSystemOrSuperUser()) {
                    User requestingUser = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (requestingUser != null ? requestingUser.getShortName() : "null") + "' is not authorized to perform this action.");
                }
                if (AccessControlLists.isGroupPrincipal(Bytes.toString(user))) {
                    try {
                        this.visibilityLabelService.getClass().getDeclaredMethod("getGroupAuths", String[].class, Boolean.TYPE);
                    }
                    catch (SecurityException e) {
                        throw new AccessDeniedException("Failed to obtain getGroupAuths implementation");
                    }
                    catch (NoSuchMethodException e) {
                        throw new AccessDeniedException("Get group auth is not supported in this implementation");
                    }
                    String group = AccessControlLists.getGroupName(Bytes.toString(user));
                    labels = this.visibilityLabelService.getGroupAuths(new String[]{group}, false);
                } else {
                    labels = this.visibilityLabelService.getAuths(user, false);
                }
                this.logResult(true, "getAuths", "Get authorizations for user allowed", user, null, null);
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "getAuths", e.getMessage(), user, null, null);
                ResponseConverter.setControllerException(controller, e);
            }
            catch (IOException e) {
                ResponseConverter.setControllerException(controller, e);
            }
            response.setUser(request.getUser());
            if (labels != null) {
                for (String label : labels) {
                    response.addAuth(ByteStringer.wrap(Bytes.toBytes(label)));
                }
            }
        }
        done.run(response.build());
    }

    @Override
    public synchronized void clearAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List<ByteString> auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), new CoprocessorException("VisibilityController not yet initialized"), response);
        } else {
            byte[] requestUser = request.getUser().toByteArray();
            ArrayList<byte[]> labelAuths = new ArrayList<byte[]>(auths.size());
            try {
                if (this.authorizationEnabled && this.accessControllerAvailable && !this.isSystemOrSuperUser()) {
                    User user = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + " is not authorized to perform this action.");
                }
                if (this.authorizationEnabled) {
                    this.checkCallingUserAuth();
                }
                for (ByteString authBS : auths) {
                    labelAuths.add(authBS.toByteArray());
                }
                OperationStatus[] opStatus = this.visibilityLabelService.clearAuths(requestUser, labelAuths);
                this.logResult(true, "clearAuths", "Removing authorization for labels allowed", requestUser, labelAuths, null);
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (OperationStatus status : opStatus) {
                    if (status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        response.addResult(successResult);
                        continue;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException(new DoNotRetryIOException(status.getExceptionMsg())));
                    response.addResult(failureResultBuilder.build());
                }
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "clearAuths", e.getMessage(), requestUser, labelAuths, null);
                LOG.error("User is not having required permissions to clear authorization", e);
                this.setExceptionResults(auths.size(), e, response);
            }
            catch (IOException e) {
                LOG.error(e);
                this.setExceptionResults(auths.size(), e, response);
            }
        }
        done.run(response.build());
    }

    @Override
    public synchronized void listLabels(RpcController controller, VisibilityLabelsProtos.ListLabelsRequest request, RpcCallback<VisibilityLabelsProtos.ListLabelsResponse> done) {
        VisibilityLabelsProtos.ListLabelsResponse.Builder response = VisibilityLabelsProtos.ListLabelsResponse.newBuilder();
        if (!this.initialized) {
            controller.setFailed("VisibilityController not yet initialized");
        } else {
            List<String> labels = null;
            String regex = request.hasRegex() ? request.getRegex() : null;
            try {
                if (this.authorizationEnabled && this.accessControllerAvailable && !this.isSystemOrSuperUser()) {
                    User requestingUser = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (requestingUser != null ? requestingUser.getShortName() : "null") + "' is not authorized to perform this action.");
                }
                labels = this.visibilityLabelService.listLabels(regex);
                this.logResult(false, "listLabels", "Listing labels allowed", null, null, regex);
            }
            catch (AccessDeniedException e) {
                this.logResult(false, "listLabels", e.getMessage(), null, null, regex);
                ResponseConverter.setControllerException(controller, e);
            }
            catch (IOException e) {
                ResponseConverter.setControllerException(controller, e);
            }
            if (labels != null && !labels.isEmpty()) {
                for (String label : labels) {
                    response.addLabel(ByteStringer.wrap(Bytes.toBytes(label)));
                }
            }
        }
        done.run(response.build());
    }

    private void checkCallingUserAuth() throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (!this.accessControllerAvailable) {
            User user = VisibilityUtils.getActiveUser();
            if (user == null) {
                throw new IOException("Unable to retrieve calling user");
            }
            boolean havingSystemAuth = false;
            try {
                this.visibilityLabelService.getClass().getDeclaredMethod("havingSystemAuth", User.class);
                havingSystemAuth = this.visibilityLabelService.havingSystemAuth(user);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                havingSystemAuth = this.visibilityLabelService.havingSystemAuth(Bytes.toBytes(user.getShortName()));
            }
            if (!havingSystemAuth) {
                throw new AccessDeniedException("User '" + user.getShortName() + "' is not authorized to perform this action.");
            }
        }
    }

    @Override
    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    static {
        RESERVED_VIS_TAG_TYPES.add((byte)2);
        RESERVED_VIS_TAG_TYPES.add((byte)4);
        RESERVED_VIS_TAG_TYPES.add((byte)7);
    }

    public static class VisibilityReplication
    extends BaseRegionServerObserver {
        private Configuration conf;
        private VisibilityLabelService visibilityLabelService;

        @Override
        public void start(CoprocessorEnvironment env) throws IOException {
            this.conf = env.getConfiguration();
            this.visibilityLabelService = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService(this.conf);
        }

        @Override
        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        @Override
        public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
            return new VisibilityReplicationEndpoint(endpoint, this.visibilityLabelService);
        }
    }

    private static class DeleteVersionVisibilityExpressionFilter
    extends FilterBase {
        private List<Tag> deleteCellVisTags;
        private Byte deleteCellVisTagsFormat;

        public DeleteVersionVisibilityExpressionFilter(List<Tag> deleteCellVisTags, Byte deleteCellVisTagsFormat) {
            this.deleteCellVisTags = deleteCellVisTags;
            this.deleteCellVisTagsFormat = deleteCellVisTagsFormat;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
            ArrayList<Tag> putVisTags = new ArrayList<Tag>();
            Byte putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
            boolean matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, this.deleteCellVisTags, this.deleteCellVisTagsFormat);
            return matchFound ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }
    }
}

