/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class VisibilityClient {
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Configuration conf, String label) throws Throwable {
        return VisibilityClient.addLabels(conf, new String[]{label});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Configuration conf, final String[] labels) throws Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.VisibilityLabelsRequest.Builder builder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
                    for (String label : labels) {
                        if (label.length() <= 0) continue;
                        VisibilityLabelsProtos.VisibilityLabel.Builder newBuilder2 = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
                        newBuilder2.setLabel(ByteStringer.wrap(Bytes.toBytes(label)));
                        builder.addVisLabel(newBuilder2.build());
                    }
                    service.addLabels(this.controller, builder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result2 = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result2.values().iterator().next();
            return visibilityLabelsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Configuration conf, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(conf, auths, user, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Configuration conf, final String user) throws Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.GetAuthsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.GetAuthsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.GetAuthsRequest.Builder getAuthReqBuilder = VisibilityLabelsProtos.GetAuthsRequest.newBuilder();
                    getAuthReqBuilder.setUser(ByteStringer.wrap(Bytes.toBytes(user)));
                    service.getAuths(this.controller, getAuthReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.GetAuthsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.GetAuthsResponse> result2 = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = result2.values().iterator().next();
            return getAuthsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Configuration conf, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(conf, auths, user, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VisibilityLabelsProtos.VisibilityLabelsResponse setOrClearAuths(Configuration conf, final String[] auths, final String user, final boolean setOrClear) throws IOException, ServiceException, Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.SetAuthsRequest.Builder setAuthReqBuilder = VisibilityLabelsProtos.SetAuthsRequest.newBuilder();
                    setAuthReqBuilder.setUser(ByteStringer.wrap(Bytes.toBytes(user)));
                    for (String auth : auths) {
                        if (auth.length() <= 0) continue;
                        setAuthReqBuilder.addAuth(ByteStringer.wrap(Bytes.toBytes(auth)));
                    }
                    if (setOrClear) {
                        service.setAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    } else {
                        service.clearAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    }
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result2 = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result2.values().iterator().next();
            return visibilityLabelsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisibilityLabelsProtos.ListLabelsResponse listLabels(Configuration conf, final String regex) throws Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.ListLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.ListLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.ListLabelsRequest.Builder listAuthLabelsReqBuilder = VisibilityLabelsProtos.ListLabelsRequest.newBuilder();
                    if (regex != null) {
                        Pattern pattern = Pattern.compile(regex);
                        listAuthLabelsReqBuilder.setRegex(pattern.toString());
                    }
                    service.listLabels(this.controller, listAuthLabelsReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.ListLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.ListLabelsResponse> result2 = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.ListLabelsResponse listLabelsResponse = result2.values().iterator().next();
            return listLabelsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }
}

