/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsValidator;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;

@InterfaceAudience.Private
public class ExpressionParser {
    private static final char CLOSE_PARAN = ')';
    private static final char OPEN_PARAN = '(';
    private static final char OR = '|';
    private static final char AND = '&';
    private static final char NOT = '!';
    private static final char SPACE = ' ';
    private static final char DOUBLE_QUOTES = '\"';

    public ExpressionNode parse(String expS) throws ParseException {
        NonLeafExpressionNode nlTop;
        expS = expS.trim();
        Stack<ExpressionNode> expStack = new Stack<ExpressionNode>();
        byte[] exp = org.apache.hadoop.hbase.util.Bytes.toBytes(expS);
        int endPos = exp.length;
        block7: for (int index2 = 0; index2 < endPos; ++index2) {
            byte b = exp[index2];
            switch (b) {
                case 40: {
                    this.processOpenParan(expStack, expS, index2);
                    index2 = this.skipSpaces(exp, index2);
                    continue block7;
                }
                case 41: {
                    this.processCloseParan(expStack, expS, index2);
                    index2 = this.skipSpaces(exp, index2);
                    continue block7;
                }
                case 38: 
                case 124: {
                    this.processANDorOROp(ExpressionParser.getOperator(b), expStack, expS, index2);
                    index2 = this.skipSpaces(exp, index2);
                    continue block7;
                }
                case 33: {
                    this.processNOTOp(expStack, expS, index2);
                    continue block7;
                }
                case 34: {
                    int labelOffset = ++index2;
                    ArrayList<Byte> list2 = new ArrayList<Byte>();
                    while (index2 < endPos && !ExpressionParser.endDoubleQuotesFound(exp[index2])) {
                        if (exp[index2] == 92 && exp[++index2] != 92 && exp[index2] != 34) {
                            throw new ParseException("invalid escaping with quotes " + expS + " at column : " + index2);
                        }
                        list2.add(exp[index2]);
                        ++index2;
                    }
                    if (index2 == endPos) {
                        throw new ParseException("No terminating quotes " + expS + " at column : " + index2);
                    }
                    byte[] array = Bytes.toArray(list2);
                    String leafExp = org.apache.hadoop.hbase.util.Bytes.toString(array).trim();
                    if (leafExp.isEmpty()) {
                        throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
                    }
                    this.processLabelExpNode(new LeafExpressionNode(leafExp), expStack, expS, index2);
                    index2 = this.skipSpaces(exp, index2);
                    continue block7;
                }
                default: {
                    int labelOffset = index2;
                    do {
                        if (VisibilityLabelsValidator.isValidAuthChar(exp[index2])) continue;
                        throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
                    } while (++index2 < endPos && !ExpressionParser.isEndOfLabel(exp[index2]));
                    String leafExp = new String(exp, labelOffset, index2 - labelOffset).trim();
                    if (leafExp.isEmpty()) {
                        throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
                    }
                    this.processLabelExpNode(new LeafExpressionNode(leafExp), expStack, expS, index2);
                    --index2;
                    index2 = this.skipSpaces(exp, index2);
                }
            }
        }
        if (expStack.size() != 1) {
            throw new ParseException("Error parsing expression " + expS);
        }
        ExpressionNode top = (ExpressionNode)expStack.pop();
        if (top == LeafExpressionNode.OPEN_PARAN_NODE) {
            throw new ParseException("Error parsing expression " + expS);
        }
        if (top instanceof NonLeafExpressionNode && ((nlTop = (NonLeafExpressionNode)top).getOperator() == Operator.NOT ? nlTop.getChildExps().size() != 1 : nlTop.getChildExps().size() != 2)) {
            throw new ParseException("Error parsing expression " + expS);
        }
        return top;
    }

    private int skipSpaces(byte[] exp, int index2) {
        while (index2 < exp.length - 1 && exp[index2 + 1] == 32) {
            ++index2;
        }
        return index2;
    }

    private void processCloseParan(Stack<ExpressionNode> expStack, String expS, int index2) throws ParseException {
        ExpressionNode thirdTop;
        NonLeafExpressionNode nlTop;
        if (expStack.size() < 2) {
            throw new ParseException();
        }
        ExpressionNode top = expStack.pop();
        ExpressionNode secondTop = expStack.pop();
        if (top == LeafExpressionNode.OPEN_PARAN_NODE || secondTop != LeafExpressionNode.OPEN_PARAN_NODE) {
            throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
        }
        if (top instanceof NonLeafExpressionNode && ((nlTop = (NonLeafExpressionNode)top).getOperator() == Operator.NOT && nlTop.getChildExps().size() != 1 || nlTop.getOperator() != Operator.NOT && nlTop.getChildExps().size() != 2)) {
            throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
        }
        if (!expStack.isEmpty() && (thirdTop = expStack.peek()) instanceof NonLeafExpressionNode) {
            ExpressionNode fourthTop;
            NonLeafExpressionNode nlThirdTop = (NonLeafExpressionNode)expStack.pop();
            nlThirdTop.addChildExp(top);
            if (nlThirdTop.getOperator() == Operator.NOT && !expStack.isEmpty() && (fourthTop = expStack.peek()) instanceof NonLeafExpressionNode) {
                NonLeafExpressionNode nlFourthTop = (NonLeafExpressionNode)fourthTop;
                assert (nlFourthTop.getOperator() != Operator.NOT);
                assert (nlFourthTop.getChildExps().size() == 1);
                nlFourthTop.addChildExp(nlThirdTop);
                return;
            }
            top = nlThirdTop;
        }
        expStack.push(top);
    }

    private void processOpenParan(Stack<ExpressionNode> expStack, String expS, int index2) throws ParseException {
        if (!expStack.isEmpty()) {
            NonLeafExpressionNode nlTop;
            ExpressionNode top = expStack.peek();
            if (top instanceof LeafExpressionNode && top != LeafExpressionNode.OPEN_PARAN_NODE) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
            if (top instanceof NonLeafExpressionNode && ((nlTop = (NonLeafExpressionNode)top).getOperator() == Operator.NOT && nlTop.getChildExps().size() != 0 || nlTop.getOperator() != Operator.NOT && nlTop.getChildExps().size() != 1)) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
        }
        expStack.push(LeafExpressionNode.OPEN_PARAN_NODE);
    }

    private void processLabelExpNode(LeafExpressionNode node, Stack<ExpressionNode> expStack, String expS, int index2) throws ParseException {
        if (expStack.isEmpty()) {
            expStack.push(node);
        } else {
            ExpressionNode top = expStack.peek();
            if (top == LeafExpressionNode.OPEN_PARAN_NODE) {
                expStack.push(node);
            } else if (top instanceof NonLeafExpressionNode) {
                NonLeafExpressionNode nlTop = (NonLeafExpressionNode)expStack.pop();
                nlTop.addChildExp(node);
                if (nlTop.getOperator() == Operator.NOT && !expStack.isEmpty()) {
                    ExpressionNode secondTop = expStack.peek();
                    if (secondTop == LeafExpressionNode.OPEN_PARAN_NODE) {
                        expStack.push(nlTop);
                    } else if (secondTop instanceof NonLeafExpressionNode) {
                        ((NonLeafExpressionNode)secondTop).addChildExp(nlTop);
                    }
                } else {
                    expStack.push(nlTop);
                }
            } else {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
        }
    }

    private void processANDorOROp(Operator op, Stack<ExpressionNode> expStack, String expS, int index2) throws ParseException {
        if (expStack.isEmpty()) {
            throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
        }
        ExpressionNode top = expStack.pop();
        if (top.isSingleNode()) {
            if (top == LeafExpressionNode.OPEN_PARAN_NODE) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
            expStack.push(new NonLeafExpressionNode(op, top));
        } else {
            NonLeafExpressionNode nlTop = (NonLeafExpressionNode)top;
            if (nlTop.getChildExps().size() != 2) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
            expStack.push(new NonLeafExpressionNode(op, nlTop));
        }
    }

    private void processNOTOp(Stack<ExpressionNode> expStack, String expS, int index2) throws ParseException {
        if (!expStack.isEmpty()) {
            ExpressionNode top = expStack.peek();
            if (top.isSingleNode() && top != LeafExpressionNode.OPEN_PARAN_NODE) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
            if (!top.isSingleNode() && ((NonLeafExpressionNode)top).getChildExps().size() != 1) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index2);
            }
        }
        expStack.push(new NonLeafExpressionNode(Operator.NOT));
    }

    private static boolean endDoubleQuotesFound(byte b) {
        return b == 34;
    }

    private static boolean isEndOfLabel(byte b) {
        return b == 40 || b == 41 || b == 124 || b == 38 || b == 33 || b == 32;
    }

    private static Operator getOperator(byte op) {
        switch (op) {
            case 38: {
                return Operator.AND;
            }
            case 124: {
                return Operator.OR;
            }
            case 33: {
                return Operator.NOT;
            }
        }
        return null;
    }
}

