/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.token.AuthenticationKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.ZKSecretWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKLeaderManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class AuthenticationTokenSecretManager
extends SecretManager<AuthenticationTokenIdentifier> {
    static final String NAME_PREFIX = "SecretManager-";
    private static Log LOG = LogFactory.getLog(AuthenticationTokenSecretManager.class);
    private long lastKeyUpdate;
    private long keyUpdateInterval;
    private long tokenMaxLifetime;
    private ZKSecretWatcher zkWatcher;
    private LeaderElector leaderElector;
    private ZKClusterId clusterId;
    private Map<Integer, AuthenticationKey> allKeys = new ConcurrentHashMap<Integer, AuthenticationKey>();
    private AuthenticationKey currentKey;
    private int idSeq;
    private AtomicLong tokenSeq = new AtomicLong();
    private String name;

    public AuthenticationTokenSecretManager(Configuration conf, ZooKeeperWatcher zk, String serverName, long keyUpdateInterval, long tokenMaxLifetime) {
        this.zkWatcher = new ZKSecretWatcher(conf, zk, this);
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenMaxLifetime = tokenMaxLifetime;
        this.leaderElector = new LeaderElector(zk, serverName);
        this.name = NAME_PREFIX + serverName;
        this.clusterId = new ZKClusterId(zk, zk);
    }

    public void start() {
        try {
            this.zkWatcher.start();
            this.leaderElector.start();
        }
        catch (KeeperException ke) {
            LOG.error("Zookeeper initialization failed", ke);
        }
    }

    public void stop() {
        this.leaderElector.stop("SecretManager stopping");
    }

    public boolean isMaster() {
        return this.leaderElector.isMaster();
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected byte[] createPassword(AuthenticationTokenIdentifier identifier) {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        AuthenticationKey secretKey = this.currentKey;
        identifier.setKeyId(secretKey.getKeyId());
        identifier.setIssueDate(now);
        identifier.setExpirationDate(now + this.tokenMaxLifetime);
        identifier.setSequenceNumber(this.tokenSeq.getAndIncrement());
        return AuthenticationTokenSecretManager.createPassword(identifier.getBytes(), secretKey.getKey());
    }

    @Override
    public byte[] retrievePassword(AuthenticationTokenIdentifier identifier) throws SecretManager.InvalidToken {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (identifier.getExpirationDate() < now) {
            throw new SecretManager.InvalidToken("Token has expired");
        }
        AuthenticationKey masterKey = this.allKeys.get(identifier.getKeyId());
        if (masterKey == null) {
            throw new SecretManager.InvalidToken("Unknown master key for token (id=" + identifier.getKeyId() + ")");
        }
        return AuthenticationTokenSecretManager.createPassword(identifier.getBytes(), masterKey.getKey());
    }

    @Override
    public AuthenticationTokenIdentifier createIdentifier() {
        return new AuthenticationTokenIdentifier();
    }

    public Token<AuthenticationTokenIdentifier> generateToken(String username) {
        AuthenticationTokenIdentifier ident2 = new AuthenticationTokenIdentifier(username);
        Token<AuthenticationTokenIdentifier> token2 = new Token<AuthenticationTokenIdentifier>(ident2, this);
        if (this.clusterId.hasId()) {
            token2.setService(new Text(this.clusterId.getId()));
        }
        return token2;
    }

    public synchronized void addKey(AuthenticationKey key) throws IOException {
        if (this.leaderElector.isMaster()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running as master, ignoring new key " + key.getKeyId());
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding key " + key.getKeyId());
        }
        this.allKeys.put(key.getKeyId(), key);
        if (this.currentKey == null || key.getKeyId() > this.currentKey.getKeyId()) {
            this.currentKey = key;
        }
        if (key.getKeyId() > this.idSeq) {
            this.idSeq = key.getKeyId();
        }
    }

    synchronized boolean removeKey(Integer keyId) {
        if (this.leaderElector.isMaster()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running as master, ignoring removed key " + keyId);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing key " + keyId);
        }
        this.allKeys.remove(keyId);
        return true;
    }

    AuthenticationKey getCurrentKey() {
        return this.currentKey;
    }

    AuthenticationKey getKey(int keyId) {
        return this.allKeys.get(keyId);
    }

    synchronized void removeExpiredKeys() {
        if (!this.leaderElector.isMaster()) {
            LOG.info("Skipping removeExpiredKeys() because not running as master.");
            return;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        Iterator<AuthenticationKey> iter2 = this.allKeys.values().iterator();
        while (iter2.hasNext()) {
            AuthenticationKey key = iter2.next();
            if (key.getExpiration() >= now) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing expired key " + key.getKeyId());
            }
            iter2.remove();
            this.zkWatcher.removeKeyFromZK(key);
        }
    }

    synchronized boolean isCurrentKeyRolled() {
        return this.currentKey != null;
    }

    synchronized void rollCurrentKey() {
        if (!this.leaderElector.isMaster()) {
            LOG.info("Skipping rollCurrentKey() because not running as master.");
            return;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        AuthenticationKey prev = this.currentKey;
        AuthenticationKey newKey = new AuthenticationKey(++this.idSeq, Long.MAX_VALUE, this.generateSecret());
        this.allKeys.put(newKey.getKeyId(), newKey);
        this.currentKey = newKey;
        this.zkWatcher.addKeyToZK(newKey);
        this.lastKeyUpdate = now;
        if (prev != null) {
            prev.setExpiration(now + this.tokenMaxLifetime);
            this.allKeys.put(prev.getKeyId(), prev);
            this.zkWatcher.updateKeyInZK(prev);
        }
    }

    public static SecretKey createSecretKey(byte[] raw2) {
        return SecretManager.createSecretKey(raw2);
    }

    private class LeaderElector
    extends Thread
    implements Stoppable {
        private boolean stopped = false;
        private boolean isMaster = false;
        private ZKLeaderManager zkLeader;

        public LeaderElector(ZooKeeperWatcher watcher, String serverName) {
            this.setDaemon(true);
            this.setName("ZKSecretWatcher-leaderElector");
            this.zkLeader = new ZKLeaderManager(watcher, ZKUtil.joinZNode(AuthenticationTokenSecretManager.this.zkWatcher.getRootKeyZNode(), "keymaster"), Bytes.toBytes(serverName), this);
        }

        public boolean isMaster() {
            return this.isMaster;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void stop(String reason) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            if (this.isMaster) {
                this.zkLeader.stepDownAsLeader();
            }
            this.isMaster = false;
            LOG.info("Stopping leader election, because: " + reason);
            this.interrupt();
        }

        @Override
        public void run() {
            this.zkLeader.start();
            this.zkLeader.waitToBecomeLeader();
            this.isMaster = true;
            while (!this.stopped) {
                long now = EnvironmentEdgeManager.currentTimeMillis();
                AuthenticationTokenSecretManager.this.removeExpiredKeys();
                if (AuthenticationTokenSecretManager.this.lastKeyUpdate + AuthenticationTokenSecretManager.this.keyUpdateInterval < now) {
                    AuthenticationTokenSecretManager.this.rollCurrentKey();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Interrupted waiting for next update", ie);
                }
            }
        }
    }
}

