/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.rest.MetricsRESTSource;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsRESTSourceImpl
extends BaseSourceImpl
implements MetricsRESTSource {
    private MutableCounterLong request;
    private MutableCounterLong sucGet;
    private MutableCounterLong sucPut;
    private MutableCounterLong sucDel;
    private MutableCounterLong sucScan;
    private MutableCounterLong fGet;
    private MutableCounterLong fPut;
    private MutableCounterLong fDel;
    private MutableCounterLong fScan;

    public MetricsRESTSourceImpl() {
        this("REST", "Metrics about the HBase REST server", "rest", "REST");
    }

    public MetricsRESTSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.request = this.getMetricsRegistry().getLongCounter("requests", 0L);
        this.sucGet = this.getMetricsRegistry().getLongCounter("successfulGet", 0L);
        this.sucPut = this.getMetricsRegistry().getLongCounter("successfulPut", 0L);
        this.sucDel = this.getMetricsRegistry().getLongCounter("successfulDelete", 0L);
        this.sucScan = this.getMetricsRegistry().getLongCounter("successfulScanCount", 0L);
        this.fGet = this.getMetricsRegistry().getLongCounter("failedGet", 0L);
        this.fPut = this.getMetricsRegistry().getLongCounter("failedPut", 0L);
        this.fDel = this.getMetricsRegistry().getLongCounter("failedDelete", 0L);
        this.fScan = this.getMetricsRegistry().getLongCounter("failedScanCount", 0L);
    }

    @Override
    public void incrementRequests(int inc) {
        this.request.incr(inc);
    }

    @Override
    public void incrementSucessfulGetRequests(int inc) {
        this.sucGet.incr(inc);
    }

    @Override
    public void incrementSucessfulPutRequests(int inc) {
        this.sucPut.incr(inc);
    }

    @Override
    public void incrementSucessfulDeleteRequests(int inc) {
        this.sucDel.incr(inc);
    }

    @Override
    public void incrementFailedGetRequests(int inc) {
        this.fGet.incr(inc);
    }

    @Override
    public void incrementFailedPutRequests(int inc) {
        this.fPut.incr(inc);
    }

    @Override
    public void incrementFailedDeleteRequests(int inc) {
        this.fDel.incr(inc);
    }

    @Override
    public void incrementSucessfulScanRequests(int inc) {
        this.sucScan.incr(inc);
    }

    @Override
    public void incrementFailedScanRequests(int inc) {
        this.fScan.incr(inc);
    }
}

