/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class ReplicationThrottler {
    private final boolean enabled;
    private final double bandwidth;
    private long cyclePushSize;
    private long cycleStartTick;

    public ReplicationThrottler(double bandwidth) {
        this.bandwidth = bandwidth;
        boolean bl = this.enabled = this.bandwidth > 0.0;
        if (this.enabled) {
            this.cyclePushSize = 0L;
            this.cycleStartTick = EnvironmentEdgeManager.currentTimeMillis();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getNextSleepInterval(int size2) {
        if (!this.enabled) {
            return 0L;
        }
        long sleepTicks = 0L;
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if ((double)this.cyclePushSize > this.bandwidth) {
            double cycles = Math.ceil((double)this.cyclePushSize / this.bandwidth);
            long shouldTillTo = this.cycleStartTick + (long)(cycles * 100.0);
            if (shouldTillTo > now) {
                sleepTicks = shouldTillTo - now;
            } else {
                this.cycleStartTick = now;
            }
            this.cyclePushSize = 0L;
        } else {
            long nextCycleTick = this.cycleStartTick + 100L;
            if (now >= nextCycleTick) {
                this.cycleStartTick = now;
                this.cyclePushSize = 0L;
            } else if (this.cyclePushSize > 0L && (double)(this.cyclePushSize + (long)size2) >= this.bandwidth) {
                sleepTicks = nextCycleTick - now;
                this.cyclePushSize = 0L;
            }
        }
        return sleepTicks;
    }

    public void addPushSize(int size2) {
        if (this.enabled) {
            this.cyclePushSize += (long)size2;
        }
    }

    public void resetStartTick() {
        if (this.enabled) {
            this.cycleStartTick = EnvironmentEdgeManager.currentTimeMillis();
        }
    }
}

