/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class TableCfWALEntryFilter
implements WALEntryFilter {
    private static final Log LOG = LogFactory.getLog(TableCfWALEntryFilter.class);
    private final ReplicationPeer peer;

    public TableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public HLog.Entry filter(HLog.Entry entry2) {
        String tabName = entry2.getKey().getTablename().getNameAsString();
        ArrayList<KeyValue> kvs = entry2.getEdit().getKeyValues();
        Map<String, List<String>> tableCFs = null;
        try {
            tableCFs = this.peer.getTableCFs();
        }
        catch (IllegalArgumentException e) {
            LOG.error("should not happen: can't get tableCFs for peer " + this.peer.getId() + ", degenerate as if it's not configured by keeping tableCFs==null");
        }
        int size2 = kvs.size();
        if (tableCFs != null && !tableCFs.containsKey(tabName)) {
            return null;
        }
        List<String> cfs = tableCFs == null ? null : tableCFs.get(tabName);
        for (int i = size2 - 1; i >= 0; --i) {
            KeyValue kv = kvs.get(i);
            if (cfs == null || cfs.contains(Bytes.toString(kv.getFamily()))) continue;
            kvs.remove(i);
        }
        if (kvs.size() < size2 / 2) {
            kvs.trimToSize();
        }
        return entry2;
    }
}

