/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.replication.WALEntryFilter;

@InterfaceAudience.Private
public class ScopeWALEntryFilter
implements WALEntryFilter {
    @Override
    public HLog.Entry filter(HLog.Entry entry2) {
        NavigableMap<byte[], Integer> scopes = entry2.getKey().getScopes();
        if (scopes == null || scopes.isEmpty()) {
            return null;
        }
        ArrayList<KeyValue> kvs = entry2.getEdit().getKeyValues();
        int size2 = kvs.size();
        for (int i = size2 - 1; i >= 0; --i) {
            KeyValue kv = kvs.get(i);
            if (scopes.containsKey(kv.getFamily()) && (Integer)scopes.get(kv.getFamily()) != 0) continue;
            kvs.remove(i);
        }
        if (kvs.size() < size2 / 2) {
            kvs.trimToSize();
        }
        return entry2;
    }
}

