/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.replication.WALEntryFilter;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class ChainWALEntryFilter
implements WALEntryFilter {
    private final WALEntryFilter[] filters;

    public ChainWALEntryFilter(WALEntryFilter ... filters) {
        this.filters = filters;
    }

    public ChainWALEntryFilter(List<WALEntryFilter> filters) {
        ArrayList<WALEntryFilter> rawFilters = new ArrayList<WALEntryFilter>(filters.size());
        for (WALEntryFilter filter2 : filters) {
            if (filter2 instanceof ChainWALEntryFilter) {
                for (WALEntryFilter f : ((ChainWALEntryFilter)filter2).filters) {
                    rawFilters.add(f);
                }
                continue;
            }
            rawFilters.add(filter2);
        }
        this.filters = rawFilters.toArray(new WALEntryFilter[rawFilters.size()]);
    }

    @Override
    public HLog.Entry filter(HLog.Entry entry2) {
        for (WALEntryFilter filter2 : this.filters) {
            if (entry2 == null) {
                return null;
            }
            entry2 = filter2.filter(entry2);
        }
        return entry2;
    }
}

