/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public abstract class ReaderBase
implements HLog.Reader {
    private static final Log LOG = LogFactory.getLog(ReaderBase.class);
    protected Configuration conf;
    protected FileSystem fs;
    protected Path path;
    protected long edit = 0L;
    protected long fileLength;
    protected WALProtos.WALTrailer trailer;
    protected int trailerWarnSize;
    protected CompressionContext compressionContext = null;
    protected boolean emptyCompressionContext = true;

    @Override
    public void init(FileSystem fs, Path path, Configuration conf, FSDataInputStream stream) throws IOException {
        this.conf = conf;
        this.path = path;
        this.fs = fs;
        this.fileLength = this.fs.getFileStatus(path).getLen();
        this.trailerWarnSize = conf.getInt("hbase.regionserver.waltrailer.warn.size", 0x100000);
        String cellCodecClsName = this.initReader(stream);
        boolean compression = this.hasCompression();
        if (compression) {
            try {
                if (this.compressionContext == null) {
                    this.compressionContext = new CompressionContext(LRUDictionary.class, FSUtils.isRecoveredEdits(path), this.hasTagCompression());
                } else {
                    this.compressionContext.clear();
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize CompressionContext", e);
            }
        }
        this.initAfterCompression(cellCodecClsName);
    }

    @Override
    public HLog.Entry next() throws IOException {
        return this.next(null);
    }

    @Override
    public HLog.Entry next(HLog.Entry reuse) throws IOException {
        HLog.Entry e = reuse;
        if (e == null) {
            e = new HLog.Entry(new HLogKey(), new WALEdit());
        }
        if (this.compressionContext != null) {
            e.setCompressionContext(this.compressionContext);
        }
        boolean hasEntry = false;
        try {
            hasEntry = this.readNext(e);
        }
        catch (IllegalArgumentException iae) {
            TableName tableName = e.getKey().getTablename();
            if (tableName != null && tableName.equals(TableName.OLD_ROOT_TABLE_NAME)) {
                LOG.info("Got an old ROOT edit, ignoring ");
                return this.next(e);
            }
            throw iae;
        }
        ++this.edit;
        if (this.compressionContext != null && this.emptyCompressionContext) {
            this.emptyCompressionContext = false;
        }
        return hasEntry ? e : null;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.compressionContext != null && this.emptyCompressionContext) {
            while (this.next() != null) {
                if (this.getPosition() != pos) continue;
                this.emptyCompressionContext = false;
                break;
            }
        }
        this.seekOnFs(pos);
    }

    protected abstract String initReader(FSDataInputStream var1) throws IOException;

    protected abstract void initAfterCompression() throws IOException;

    protected abstract void initAfterCompression(String var1) throws IOException;

    protected abstract boolean hasCompression();

    protected abstract boolean hasTagCompression();

    protected abstract boolean readNext(HLog.Entry var1) throws IOException;

    protected abstract void seekOnFs(long var1) throws IOException;

    @Override
    public WALProtos.WALTrailer getWALTrailer() {
        return null;
    }
}

