/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsWALSourceImpl
extends BaseSourceImpl
implements MetricsWALSource {
    private final MetricHistogram appendSizeHisto;
    private final MetricHistogram appendTimeHisto = this.getMetricsRegistry().newHistogram("appendTime", "Time an append to the log took.");
    private final MetricHistogram syncTimeHisto;
    private final MutableCounterLong appendCount;
    private final MutableCounterLong slowAppendCount;
    private final MutableCounterLong logRollRequested;
    private final MutableCounterLong lowReplicationLogRollRequested;

    public MetricsWALSourceImpl() {
        this("WAL", "Metrics about HBase RegionServer HLog", "regionserver", "RegionServer,sub=WAL");
    }

    public MetricsWALSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.appendSizeHisto = this.getMetricsRegistry().newHistogram("appendSize", "Size (in bytes) of the data appended to the HLog.");
        this.appendCount = this.getMetricsRegistry().newCounter("appendCount", "Number of appends to the write ahead log.", 0L);
        this.slowAppendCount = this.getMetricsRegistry().newCounter("slowAppendCount", "Number of appends that were slow.", 0L);
        this.syncTimeHisto = this.getMetricsRegistry().newHistogram("syncTime", "The time it took to sync the HLog to HDFS.");
        this.logRollRequested = this.getMetricsRegistry().newCounter("rollRequest", "How many times a log roll has been requested total", 0L);
        this.lowReplicationLogRollRequested = this.getMetricsRegistry().newCounter("lowReplicaRollRequest", "How many times a log roll was requested due to too few DN's in the write pipeline.", 0L);
    }

    @Override
    public void incrementAppendSize(long size2) {
        this.appendSizeHisto.add(size2);
    }

    @Override
    public void incrementAppendTime(long time) {
        this.appendTimeHisto.add(time);
    }

    @Override
    public void incrementAppendCount() {
        this.appendCount.incr();
    }

    @Override
    public void incrementSlowAppendCount() {
        this.slowAppendCount.incr();
    }

    @Override
    public void incrementSyncTime(long time) {
        this.syncTimeHisto.add(time);
    }

    @Override
    public void incrementLogRollRequested() {
        this.logRollRequested.incr();
    }

    @Override
    public void incrementLowReplicationLogRoll() {
        this.lowReplicationLogRollRequested.incr();
    }
}

