/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.wal.MetricsEditsReplaySource;
import org.apache.hadoop.metrics2.MetricHistogram;

@InterfaceAudience.Private
public class MetricsEditsReplaySourceImpl
extends BaseSourceImpl
implements MetricsEditsReplaySource {
    private static final Log LOG = LogFactory.getLog(MetricsEditsReplaySourceImpl.class.getName());
    private MetricHistogram replayTimeHisto;
    private MetricHistogram replayBatchSizeHisto;
    private MetricHistogram replayDataSizeHisto;

    public MetricsEditsReplaySourceImpl() {
        this("replay", "Metrics about HBase RegionServer HLog Edits Replay", "regionserver", "RegionServer,sub=replay");
    }

    public MetricsEditsReplaySourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.replayTimeHisto = this.metricsRegistry.newHistogram("replayTime", "Time an replay operation took.");
        this.replayBatchSizeHisto = this.metricsRegistry.newHistogram("replayBatchSize", "Number of changes in each replay batch.");
        this.replayDataSizeHisto = this.metricsRegistry.newHistogram("replayDataSize", "Size (in bytes) of the data of each replay.");
    }

    @Override
    public void updateReplayTime(long time) {
        this.replayTimeHisto.add(time);
    }

    @Override
    public void updateReplayBatchSize(long size2) {
        this.replayBatchSizeHisto.add(size2);
    }

    @Override
    public void updateReplayDataSize(long size2) {
        this.replayDataSizeHisto.add(size2);
    }
}

