/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class HLogKey
implements WritableComparable<HLogKey> {
    public static final Log LOG = LogFactory.getLog(HLogKey.class);
    private static final String PREFIX_CLUSTER_KEY = ".";
    private static final Version VERSION = Version.COMPRESSED;
    private byte[] encodedRegionName;
    private TableName tablename;
    private long logSeqNum;
    private long writeTime;
    private List<UUID> clusterIds;
    private NavigableMap<byte[], Integer> scopes;
    private long nonceGroup = 0L;
    private long nonce = 0L;
    private CompressionContext compressionContext;

    public HLogKey() {
        this.init(null, null, 0L, Long.MAX_VALUE, new ArrayList<UUID>(), 0L, 0L);
    }

    @VisibleForTesting
    public HLogKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, UUID clusterId) {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        clusterIds.add(clusterId);
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, 0L, 0L);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce) {
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, nonceGroup, nonce);
    }

    protected void init(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce) {
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
        this.clusterIds = clusterIds;
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
        this.nonceGroup = nonceGroup;
        this.nonce = nonce;
    }

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public TableName getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public NavigableMap<byte[], Integer> getScopes() {
        return this.scopes;
    }

    public long getNonceGroup() {
        return this.nonceGroup;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setScopes(NavigableMap<byte[], Integer> scopes) {
        this.scopes = scopes;
    }

    public void readOlderScopes(NavigableMap<byte[], Integer> scopes) {
        if (scopes != null) {
            Iterator iterator2 = scopes.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry scope = iterator2.next();
                String key = Bytes.toString((byte[])scope.getKey());
                if (!key.startsWith(PREFIX_CLUSTER_KEY)) continue;
                this.addClusterId(UUID.fromString(key.substring(PREFIX_CLUSTER_KEY.length())));
                iterator2.remove();
            }
            if (scopes.size() > 0) {
                this.scopes = scopes;
            }
        }
    }

    public void addClusterId(UUID clusterId) {
        if (!this.clusterIds.contains(clusterId)) {
            this.clusterIds.add(clusterId);
        }
    }

    public List<UUID> getClusterIds() {
        return this.clusterIds;
    }

    public UUID getOriginatingClusterId() {
        return this.clusterIds.isEmpty() ? HConstants.DEFAULT_CLUSTER_ID : this.clusterIds.get(0);
    }

    public String toString() {
        return this.tablename + "/" + Bytes.toString(this.encodedRegionName) + "/" + this.logSeqNum;
    }

    public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", this.tablename);
        stringMap.put("region", Bytes.toStringBinary(this.encodedRegionName));
        stringMap.put("sequence", this.logSeqNum);
        return stringMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HLogKey)obj) == 0;
    }

    public int hashCode() {
        int result2 = Bytes.hashCode(this.encodedRegionName);
        result2 = (int)((long)result2 ^ this.logSeqNum);
        result2 = (int)((long)result2 ^ this.writeTime);
        return result2;
    }

    @Override
    public int compareTo(HLogKey o) {
        int result2 = Bytes.compareTo(this.encodedRegionName, o.encodedRegionName);
        if (result2 == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result2 = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result2 = 1;
            }
            if (result2 == 0) {
                if (this.writeTime < o.writeTime) {
                    result2 = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result2;
    }

    void internTableName(TableName tablename) {
        assert (tablename.equals(this.tablename));
        this.tablename = tablename;
    }

    void internEncodedRegionName(byte[] encodedRegionName) {
        assert (Bytes.equals(this.encodedRegionName, encodedRegionName));
        this.encodedRegionName = encodedRegionName;
    }

    @Override
    @Deprecated
    public void write(DataOutput out) throws IOException {
        LOG.warn("HLogKey is being serialized to writable - only expected in test code");
        WritableUtils.writeVInt(out, HLogKey.VERSION.code);
        if (this.compressionContext == null) {
            Bytes.writeByteArray(out, this.encodedRegionName);
            Bytes.writeByteArray(out, this.tablename.getName());
        } else {
            Compressor.writeCompressed(this.encodedRegionName, 0, this.encodedRegionName.length, out, this.compressionContext.regionDict);
            Compressor.writeCompressed(this.tablename.getName(), 0, this.tablename.getName().length, out, this.compressionContext.tableDict);
        }
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
        Iterator<UUID> iterator2 = this.clusterIds.iterator();
        if (iterator2.hasNext()) {
            out.writeBoolean(true);
            UUID clusterId = iterator2.next();
            out.writeLong(clusterId.getMostSignificantBits());
            out.writeLong(clusterId.getLeastSignificantBits());
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Version version = Version.UNVERSIONED;
        this.scopes = null;
        int len = WritableUtils.readVInt(in);
        byte[] tablenameBytes = null;
        if (len < 0) {
            version = Version.fromCode(len);
            if (this.compressionContext == null || !version.atLeast(Version.COMPRESSED)) {
                len = WritableUtils.readVInt(in);
            }
        }
        if (this.compressionContext == null || !version.atLeast(Version.COMPRESSED)) {
            this.encodedRegionName = new byte[len];
            in.readFully(this.encodedRegionName);
            tablenameBytes = Bytes.readByteArray(in);
        } else {
            this.encodedRegionName = Compressor.readCompressed(in, this.compressionContext.regionDict);
            tablenameBytes = Compressor.readCompressed(in, this.compressionContext.tableDict);
        }
        this.logSeqNum = in.readLong();
        this.writeTime = in.readLong();
        this.clusterIds.clear();
        if (version.atLeast(Version.INITIAL)) {
            if (in.readBoolean()) {
                this.clusterIds.add(new UUID(in.readLong(), in.readLong()));
            }
        } else {
            try {
                in.readByte();
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
        try {
            this.tablename = TableName.valueOf(tablenameBytes);
        }
        catch (IllegalArgumentException iae) {
            if (Bytes.toString(tablenameBytes).equals(".META.")) {
                LOG.info("Got an old .META. edit, continuing with new format ");
                this.tablename = TableName.META_TABLE_NAME;
                this.encodedRegionName = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
            }
            if (Bytes.toString(tablenameBytes).equals("-ROOT-")) {
                this.tablename = TableName.OLD_ROOT_TABLE_NAME;
                throw iae;
            }
            throw iae;
        }
    }

    public WALProtos.WALKey.Builder getBuilder(WALCellCodec.ByteStringCompressor compressor) throws IOException {
        WALProtos.WALKey.Builder builder = WALProtos.WALKey.newBuilder();
        if (this.compressionContext == null) {
            builder.setEncodedRegionName(ByteStringer.wrap(this.encodedRegionName));
            builder.setTableName(ByteStringer.wrap(this.tablename.getName()));
        } else {
            builder.setEncodedRegionName(compressor.compress(this.encodedRegionName, this.compressionContext.regionDict));
            builder.setTableName(compressor.compress(this.tablename.getName(), this.compressionContext.tableDict));
        }
        builder.setLogSequenceNumber(this.logSeqNum);
        builder.setWriteTime(this.writeTime);
        if (this.nonce != 0L) {
            builder.setNonce(this.nonce);
        }
        if (this.nonceGroup != 0L) {
            builder.setNonceGroup(this.nonceGroup);
        }
        HBaseProtos.UUID.Builder uuidBuilder = HBaseProtos.UUID.newBuilder();
        for (UUID uUID : this.clusterIds) {
            uuidBuilder.setLeastSigBits(uUID.getLeastSignificantBits());
            uuidBuilder.setMostSigBits(uUID.getMostSignificantBits());
            builder.addClusterIds(uuidBuilder.build());
        }
        if (this.scopes != null) {
            for (Map.Entry entry2 : this.scopes.entrySet()) {
                ByteString family = this.compressionContext == null ? ByteStringer.wrap((byte[])entry2.getKey()) : compressor.compress((byte[])entry2.getKey(), this.compressionContext.familyDict);
                builder.addScopes(WALProtos.FamilyScope.newBuilder().setFamily(family).setScopeType(WALProtos.ScopeType.valueOf((Integer)entry2.getValue())));
            }
        }
        return builder;
    }

    public void readFieldsFromPb(WALProtos.WALKey walKey, WALCellCodec.ByteStringUncompressor uncompressor) throws IOException {
        if (this.compressionContext != null) {
            this.encodedRegionName = uncompressor.uncompress(walKey.getEncodedRegionName(), this.compressionContext.regionDict);
            byte[] tablenameBytes = uncompressor.uncompress(walKey.getTableName(), this.compressionContext.tableDict);
            this.tablename = TableName.valueOf(tablenameBytes);
        } else {
            this.encodedRegionName = walKey.getEncodedRegionName().toByteArray();
            this.tablename = TableName.valueOf(walKey.getTableName().toByteArray());
        }
        this.clusterIds.clear();
        if (walKey.hasClusterId()) {
            this.clusterIds.add(new UUID(walKey.getClusterId().getMostSigBits(), walKey.getClusterId().getLeastSigBits()));
        }
        for (HBaseProtos.UUID clusterId : walKey.getClusterIdsList()) {
            this.clusterIds.add(new UUID(clusterId.getMostSigBits(), clusterId.getLeastSigBits()));
        }
        if (walKey.hasNonceGroup()) {
            this.nonceGroup = walKey.getNonceGroup();
        }
        if (walKey.hasNonce()) {
            this.nonce = walKey.getNonce();
        }
        this.scopes = null;
        if (walKey.getScopesCount() > 0) {
            this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (WALProtos.FamilyScope scope : walKey.getScopesList()) {
                byte[] family = this.compressionContext == null ? scope.getFamily().toByteArray() : uncompressor.uncompress(scope.getFamily(), this.compressionContext.familyDict);
                this.scopes.put(family, scope.getScopeType().getNumber());
            }
        }
        this.logSeqNum = walKey.getLogSequenceNumber();
        this.writeTime = walKey.getWriteTime();
    }

    static enum Version {
        UNVERSIONED(0),
        INITIAL(-1),
        COMPRESSED(-2);

        final int code;
        static final Version[] byCode;

        private Version(int code) {
            this.code = code;
        }

        boolean atLeast(Version other) {
            return this.code <= other.code;
        }

        static Version fromCode(int code) {
            return byCode[code * -1];
        }

        static {
            byCode = Version.values();
            for (int i = 0; i < byCode.length; ++i) {
                if (Version.byCode[i].code != -1 * i) {
                    throw new AssertionError((Object)"Values in this enum should be descending by one");
                }
            }
        }
    }
}

