/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class Compressor {
    public static void main(String[] args) throws IOException {
        if (args.length != 2 || args[0].equals("--help") || args[0].equals("-h")) {
            Compressor.printHelp();
            System.exit(-1);
        }
        Path inputPath = new Path(args[0]);
        Path outputPath = new Path(args[1]);
        Compressor.transformFile(inputPath, outputPath);
    }

    private static void printHelp() {
        System.err.println("usage: Compressor <input> <output>");
        System.err.println("If <input> HLog is compressed, <output> will be decompressed.");
        System.err.println("If <input> HLog is uncompressed, <output> will be compressed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformFile(Path input2, Path output) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        FileSystem inFS = input2.getFileSystem(conf);
        FileSystem outFS = output.getFileSystem(conf);
        HLog.Reader in = HLogFactory.createReader(inFS, input2, conf, null, false);
        HLog.Writer out = null;
        try {
            if (!(in instanceof ReaderBase)) {
                System.err.println("Cannot proceed, invalid reader type: " + in.getClass().getName());
                return;
            }
            boolean compress = ((ReaderBase)in).hasCompression();
            conf.setBoolean("hbase.regionserver.wal.enablecompression", !compress);
            out = HLogFactory.createWALWriter(outFS, output, conf);
            HLog.Entry e = null;
            while ((e = in.next()) != null) {
                out.append(e);
            }
        }
        finally {
            in.close();
            if (out != null) {
                out.close();
                out = null;
            }
        }
    }

    @Deprecated
    static byte[] readCompressed(DataInput in, Dictionary dict) throws IOException {
        byte status = in.readByte();
        if (status == -1) {
            int length = WritableUtils.readVInt(in);
            byte[] arr = new byte[length];
            in.readFully(arr);
            if (dict != null) {
                dict.addEntry(arr, 0, length);
            }
            return arr;
        }
        short dictIdx = Compressor.toShort(status, in.readByte());
        byte[] entry2 = dict.getEntry(dictIdx);
        if (entry2 == null) {
            throw new IOException("Missing dictionary entry for index " + dictIdx);
        }
        return entry2;
    }

    @Deprecated
    static int uncompressIntoArray(byte[] to2, int offset, DataInput in, Dictionary dict) throws IOException {
        byte[] entry2;
        byte status = in.readByte();
        if (status == -1) {
            int length = WritableUtils.readVInt(in);
            in.readFully(to2, offset, length);
            dict.addEntry(to2, offset, length);
            return length;
        }
        short dictIdx = Compressor.toShort(status, in.readByte());
        try {
            entry2 = dict.getEntry(dictIdx);
        }
        catch (Exception ex) {
            throw new IOException("Unable to uncompress the log entry", ex);
        }
        if (entry2 == null) {
            throw new IOException("Missing dictionary entry for index " + dictIdx);
        }
        Bytes.putBytes(to2, offset, entry2, 0, entry2.length);
        return entry2.length;
    }

    @Deprecated
    static void writeCompressed(byte[] data2, int offset, int length, DataOutput out, Dictionary dict) throws IOException {
        int dictIdx = -1;
        if (dict != null) {
            dictIdx = dict.findEntry(data2, offset, length);
        }
        if (dictIdx == -1) {
            out.writeByte(-1);
            WritableUtils.writeVInt(out, length);
            out.write(data2, offset, length);
        } else {
            out.writeShort(dictIdx);
        }
    }

    static short toShort(byte hi, byte lo) {
        short s2 = (short)((hi & 0xFF) << 8 | lo & 0xFF);
        Preconditions.checkArgument(s2 >= 0);
        return s2;
    }
}

