/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class HLogSplitterHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(HLogSplitterHandler.class);
    private final ServerName serverName;
    private final String curTask;
    private final String wal;
    private final ZooKeeperWatcher zkw;
    private final CancelableProgressable reporter;
    private final AtomicInteger inProgressTasks;
    private final MutableInt curTaskZKVersion;
    private final SplitLogWorker.TaskExecutor splitTaskExecutor;
    private final ZooKeeperProtos.SplitLogTask.RecoveryMode mode;

    public HLogSplitterHandler(Server server, String curTask, MutableInt curTaskZKVersion, CancelableProgressable reporter, AtomicInteger inProgressTasks, SplitLogWorker.TaskExecutor splitTaskExecutor, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
        super(server, EventType.RS_LOG_REPLAY);
        this.curTask = curTask;
        this.wal = ZKSplitLog.getFileName(curTask);
        this.reporter = reporter;
        this.inProgressTasks = inProgressTasks;
        this.inProgressTasks.incrementAndGet();
        this.serverName = server.getServerName();
        this.zkw = server.getZooKeeper();
        this.curTaskZKVersion = curTaskZKVersion;
        this.splitTaskExecutor = splitTaskExecutor;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process() throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            SplitLogWorker.TaskExecutor.Status status = this.splitTaskExecutor.exec(this.wal, this.mode, this.reporter);
            switch (status) {
                case DONE: {
                    HLogSplitterHandler.endTask(this.zkw, new SplitLogTask.Done(this.serverName, this.mode), SplitLogCounters.tot_wkr_task_done, this.curTask, this.curTaskZKVersion.intValue());
                    return;
                }
                case PREEMPTED: {
                    SplitLogCounters.tot_wkr_preempt_task.incrementAndGet();
                    LOG.warn("task execution prempted " + this.wal);
                    return;
                }
                case ERR: {
                    if (this.server != null && !this.server.isStopped()) {
                        HLogSplitterHandler.endTask(this.zkw, new SplitLogTask.Err(this.serverName, this.mode), SplitLogCounters.tot_wkr_task_err, this.curTask, this.curTaskZKVersion.intValue());
                        return;
                    }
                }
                case RESIGNED: {
                    if (this.server != null && this.server.isStopped()) {
                        LOG.info("task execution interrupted because worker is exiting " + this.curTask);
                    }
                    HLogSplitterHandler.endTask(this.zkw, new SplitLogTask.Resigned(this.serverName, this.mode), SplitLogCounters.tot_wkr_task_resigned, this.curTask, this.curTaskZKVersion.intValue());
                    return;
                }
            }
            return;
        }
        finally {
            LOG.info("worker " + this.serverName + " done with task " + this.curTask + " in " + (System.currentTimeMillis() - startTime) + "ms");
            this.inProgressTasks.decrementAndGet();
        }
    }

    public static void endTask(ZooKeeperWatcher zkw, SplitLogTask slt, AtomicLong ctr, String task, int taskZKVersion) {
        try {
            if (ZKUtil.setData(zkw, task, slt.toByteArray(), taskZKVersion)) {
                LOG.info("successfully transitioned task " + task + " to final state " + slt);
                ctr.incrementAndGet();
                return;
            }
            LOG.warn("failed to transistion task " + task + " to end state " + slt + " because of version mismatch ");
        }
        catch (KeeperException.BadVersionException bve) {
            LOG.warn("transisition task " + task + " to " + slt + " failed because of version mismatch", bve);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.fatal("logic error - end task " + task + " " + slt + " failed because task doesn't exist", e);
        }
        catch (KeeperException e) {
            LOG.warn("failed to end task, " + task + " " + slt, e);
        }
        SplitLogCounters.tot_wkr_final_transition_failed.incrementAndGet();
    }
}

