/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class CloseRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CloseRegionHandler.class);
    private final int FAILED = -1;
    int expectedVersion = -1;
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private final boolean abort;
    private final boolean zk;
    private ServerName destination;
    private final boolean useZKForAssignment;

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo) {
        this(server, rsServices, regionInfo, false, true, -1, EventType.M_RS_CLOSE_REGION, null);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode) {
        this(server, rsServices, regionInfo, abort, zk, versionOfClosingNode, EventType.M_RS_CLOSE_REGION, null);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode, ServerName destination) {
        this(server, rsServices, regionInfo, abort, zk, versionOfClosingNode, EventType.M_RS_CLOSE_REGION, destination);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode, EventType eventType) {
        this(server, rsServices, regionInfo, abort, zk, versionOfClosingNode, eventType, null);
    }

    protected CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode, EventType eventType, ServerName destination) {
        super(server, eventType);
        this.server = server;
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.abort = abort;
        this.zk = zk;
        this.expectedVersion = versionOfClosingNode;
        this.destination = destination;
        this.useZKForAssignment = ConfigUtil.useZKForAssignment(server.getConfiguration());
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            String name = this.regionInfo.getRegionNameAsString();
            LOG.debug("Processing close of " + name);
            String encodedRegionName = this.regionInfo.getEncodedName();
            HRegion region = this.rsServices.getFromOnlineRegions(encodedRegionName);
            if (region == null) {
                LOG.warn("Received CLOSE for region " + name + " but currently not serving - ignoring");
                if (this.zk) {
                    LOG.error("The znode is not modified as we are not serving " + name);
                }
                return;
            }
            if (this.zk && this.useZKForAssignment && !ZKAssign.checkClosingState(this.server.getZooKeeper(), this.regionInfo, this.expectedVersion)) {
                return;
            }
            if (region.close(this.abort) == null) {
                LOG.warn("Can't close region: was already closed during close(): " + this.regionInfo.getRegionNameAsString());
                return;
            }
            this.rsServices.removeFromOnlineRegions(region, this.destination);
            if (!this.useZKForAssignment) {
                this.rsServices.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, this.regionInfo);
            } else if (this.zk) {
                if (this.setClosedState(this.expectedVersion, region)) {
                    LOG.debug("Set closed state in zk for " + name + " on " + this.server.getServerName());
                } else {
                    LOG.debug("Set closed state in zk UNSUCCESSFUL for " + name + " on " + this.server.getServerName());
                }
            }
            LOG.debug("Closed " + region.getRegionNameAsString());
        }
        finally {
            this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        }
    }

    private boolean setClosedState(int expectedVersion, HRegion region) {
        try {
            if (ZKAssign.transitionNodeClosed(this.server.getZooKeeper(), this.regionInfo, this.server.getServerName(), expectedVersion) == -1) {
                LOG.warn("Completed the CLOSE of a region but when transitioning from  CLOSING to CLOSED got a version mismatch, someone else clashed so now unassigning");
                region.close();
                return false;
            }
        }
        catch (NullPointerException e) {
            LOG.warn("NPE during close -- catching and continuing...", e);
            return false;
        }
        catch (KeeperException e) {
            LOG.error("Failed transitioning node from CLOSING to CLOSED", e);
            return false;
        }
        catch (IOException e) {
            LOG.error("Failed to close region after failing to transition", e);
            return false;
        }
        return true;
    }
}

