/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreFile;

@InterfaceAudience.Private
public class StoreUtils {
    public static Integer getDeterministicRandomSeed(Collection<StoreFile> files) {
        if (files != null && !files.isEmpty()) {
            return files.iterator().next().getPath().getName().hashCode();
        }
        return null;
    }

    public static boolean hasReferences(Collection<StoreFile> files) {
        if (files != null) {
            for (StoreFile hsf : files) {
                if (!hsf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    public static long getLowestTimestamp(Collection<StoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        for (StoreFile storeFile : candidates) {
            minTs = Math.min(minTs, storeFile.getModificationTimeStamp());
        }
        return minTs;
    }

    static StoreFile getLargestFile(Collection<StoreFile> candidates) {
        long maxSize = -1L;
        StoreFile largestSf = null;
        for (StoreFile sf : candidates) {
            long size2;
            StoreFile.Reader r = sf.getReader();
            if (r == null || (size2 = r.length()) <= maxSize) continue;
            maxSize = size2;
            largestSf = sf;
        }
        return largestSf;
    }
}

